﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

//!< エラーコードをログとして出力します。
inline void PrintError(
    const ::std::string& arg1) NN_NOEXCEPT
{
    NN_LOG("[Serial Flash Tool] Error :%s\n", arg1.c_str());
}

//!< エラーコードをログとして出力します。
inline void PrintError(
    const ::nn::Result& arg1, const ::std::string& arg2
    ) NN_NOEXCEPT
{
    NN_LOG("[Serial Flash Tool] Error :%03d-%04d:%s\n",
        arg1.GetModule(), arg1.GetDescription(),
        arg2.c_str());
}
