@echo off

setlocal
set PATH=%WINDIR%;%WINDIR%\System32;%~dp0

pushd %~dp0
cd ..\..\..\..
set NINTENDO_SDK_ROOT=%cd%
popd

set RUN_ON_TARGET=%NINTENDO_SDK_ROOT%\Tools\CommandLineTools\RunOnTarget.exe
set DEVMENU_COMMAND_SYSTEM=%NINTENDO_SDK_ROOT%\TargetTools\NX-NXFP2-a64\DevMenuCommandSystem\Release\DevMenuCommandSystem.nsp
set UPDATER=%NINTENDO_SDK_ROOT%\TargetTools\NX-NXFP2-a64\ControllerFirmwareUpdater\Release\ControllerFirmwareUpdater.nsp
set DEBUG_FW_PROGRAM_ID=0x010000000000b22b

echo ---------------------------------------------------------------------------
echo %0
echo ---------------------------------------------------------------------------

echo Please input a mode number and press Enter key.
echo   [0] Use pre-installed firmware (these are used until NX Addon 3.0.0)
echo   [1] Use hotfix required firmware (older than pre-installed)
echo   [2] Use broken firmware (MCU firmware is broken)

set /p input=">"
if defined input set INPUT=%input:"=%
if /i "%INPUT%" == "0" goto UsePreInstallFw
if /i "%INPUT%" == "1" goto UseNeedHotfixFw
if /i "%INPUT%" == "2" goto UseBrokenFw

echo Error: Invalid mode is specified.
goto Finish

:UsePreInstallFw
set FW_NSP=%NINTENDO_SDK_ROOT%\Resources\ControllerFirmware\NX\ForDebug\Release\ControllerFirmwareDebug.nsp
goto Run

:UseNeedHotfixFw
set FW_NSP=%NINTENDO_SDK_ROOT%\Resources\ControllerFirmware\NX\ForDebugNeedHotfix\Release\ControllerFirmwareDebugNeedHotfix.nsp
goto Run

:UseBrokenFw
set FW_NSP=%NINTENDO_SDK_ROOT%\Resources\ControllerFirmware\NX\ForDebugBroken\Release\ControllerFirmwareDebugBroken.nsp
goto Run

:Run

:: nsp ̃o[WɂĂ͏㏑łȂƂ̂ŁAUACXg[
echo Removing debug firmware...
%RUN_ON_TARGET% %DEVMENU_COMMAND_SYSTEM% -- systemprogram uninstall %DEBUG_FW_PROGRAM_ID%

echo Preparing debug firmware...
%RUN_ON_TARGET% %DEVMENU_COMMAND_SYSTEM% -- systemprogram install "%FW_NSP%"

echo Running firmware updater...
%RUN_ON_TARGET% %UPDATER% --no-wait -- --debug

:Finish
pause
endlocal
exit
