﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace BluetoothSettingTool {

// bluetooth
const uint32_t REMOTE_COUNT_MAX = 8;

// display

const uint32_t DISPLAY_TITLE_START_X   = 10;
const uint32_t DISPLAY_TITLE_START_Y   = 70;
const uint32_t DISPLAY_CONTENT_START_X = 30;
const uint32_t DISPLAY_CONTENT_START_Y = 110;
const uint32_t DISPLAY_PAD_START_X     = 15;
const uint32_t DISPLAY_PAD_START_Y     = 680;

const uint32_t DISPLAY_LINE_HEIGHT     = 32;

const float DEFAULT_FIXED_WIDTH        = 20;
const float DEFAULT_FONT_WIDTH         = 24;
const float DEFAULT_FONT_HEIGHT        = 30;
const uint32_t DISPLAY_CONTENT_HEIGHT  = DISPLAY_PAD_START_Y - DISPLAY_CONTENT_START_Y - 20;
extern const char* DISPLAY_SEPARATOR;

enum Button
{
    START = 0,
    SELECT,
    A,
    B,
    X,
    Y,
    L,
    R,
    ZL,
    ZR,
    LEFT,
    UP,
    RIGHT,
    DOWN,
    SL,       // stick left emulation
    SL_LEFT,
    SL_UP,
    SL_RIGHT,
    SL_DOWN,
    SR,      // stick right emulation
    SR_LEFT,
    SR_UP,
    SR_RIGHT,
    SR_DOWN,
    MINUS,
    PLUS
};

}   // namespace BluetoothSettingTool
