﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <nn/os.h>

#include "BluetoothSettingTool_Display.h"
#include "BluetoothSettingTool_Pad.h"
#include "BluetoothSettingTool_UIControl.h"
#include "BluetoothSettingTool_Selector.h"

namespace BluetoothSettingTool {

enum ProgramId
{
    PROGRAM_ID_DEFAULT = 0,
    PROGRAM_ID_APPLICATION,
};


class Program
{
protected:
    ProgramId m_ProgramId;
public:
    Program()
    {
        m_ProgramId = PROGRAM_ID_DEFAULT;
    }
    virtual ~Program(){}
    virtual void Execute(){}
    virtual void Exit(){}
    virtual ProgramId GetProgramId() const
    {
        return m_ProgramId;
    }
};


class Application : public Program
{
private:
    bool m_NeedExit;

protected:
    virtual void ApplicationImpl(){}
    virtual void Initialize(){}
    virtual void Finalize(){}

public:
    Application()
    {
        m_NeedExit = false;
    }

    virtual ~Application()
    {
        Exit();
    }

    virtual void Execute()
    {
        Initialize();

        m_NeedExit = false;
        Pad &pad = Pad::GetInstance();
        while( !m_NeedExit )
        {
            pad.UpdatePadState();
            ApplicationImpl();
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10)); // 少しウェイトを入れる
            Display::GetInstance().SwapBuffer();
        }

        Finalize();
    }

    virtual void Exit()
    {
        m_NeedExit = true;
    }
};


} // WlanTest
