﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Base/BcatTestApp_ConsoleCore.h"

namespace app
{
        // システムコンソール背景色
    const int DrawColorSet_SystemConsoleBack = 0x00006080;
    const int DrawPriority_SystemConsole = 9000;
    const int DrawPriority_ScreenConsole = 1000;

    void DrawConsoleString_FontSize16( int x, int y, char* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;
    void DrawConsoleString_FontSize24( int x, int y, char* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;

    app::ScrollConsole<char>& GetSystemConsole() NN_NOEXCEPT;
    app::FixedProportionalConsole<char>& GetScreenConsole() NN_NOEXCEPT;
    app::FixedConsole<char16_t>& GetHelpConsole() NN_NOEXCEPT;

    void SwitchSystemConsoleStatus( bool sw1, bool sw2 ) NN_NOEXCEPT;

    void DrawConsoles( void* arg ) NN_NOEXCEPT;
    void InitializeConsole();

    //
    void PrintErrorCode( nn::Result& result ) NN_NOEXCEPT;
    void DrawFixedConsoleGeneric( int sx, int sy, int lsy, int fontSize, int fx, int fy, int x, int y, char* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;
    void DrawFixedConsoleGeneric( int sx, int sy, float fontSize, float fx, float fy, int x, int y, char* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;
    void DrawFixedConsoleGeneric16( int sx, int sy, float fontSize, float fx, float fy, int x, int y, char16_t* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;

    void DrawProportionalConsoleGeneric( int sx, int sy, int lsy, int fontSize, int fx, int fy, int x, int y, char* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;
    void DrawProportionalConsoleGeneric( int sx, int sy, float fontSize, float fx, float fy, int x, int y, char* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;
    void DrawProportionalConsoleGeneric16( int sx, int sy, float fontSize, float fx, float fy, int x, int y, char16_t* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT;
}
