﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>

namespace app
{
    // 言語
    bool IsEnglish() NN_NOEXCEPT;
    void SetEnglish( bool isEnglish ) NN_NOEXCEPT;

    // 現在の接続状態
    bool IsConnected() NN_NOEXCEPT;
    void SetNetworkConnectionStatus( bool isConnected ) NN_NOEXCEPT;

    // 現在のマウント状態
    bool IsMountedCacheStorage() NN_NOEXCEPT;

    // 現在のアプリ
    void SetCurrentApplication( nn::ApplicationId& app ) NN_NOEXCEPT;
    nn::ApplicationId& GetCurrentApplication() NN_NOEXCEPT;
    bool IsCurrentApplicationAvailable() NN_NOEXCEPT;
    void ResetCurrentApplication() NN_NOEXCEPT;

    // マウント・アンマウント
    nn::Result MountCacheStorage() NN_NOEXCEPT;
    void UnmountCacheStorage() NN_NOEXCEPT;

    // 時間を取得
    bool GetCurrentTime( int* pYear, int* pMonth, int* mDay, int* pHour, int* Minute, int* Second ) NN_NOEXCEPT;

    // ベース情報表示のセットアップ
    void SetUpBaseDisplay() NN_NOEXCEPT;

} //namespace app
