﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <glv.h>

#include "BcatTestApp_Hid.h"

namespace app
{

void Pad::SetEvents( const glv::HidEvents& events ) NN_NOEXCEPT
{
    m_Dpad = events.GetDebugPad();
    m_BpadCount = events.GetAvailableBasicPadCount();
    m_Bpad = events.GetBasicPad(0);

    m_Touches = events.GetTouches();
    m_TouchCount = m_Touches.GetTouchCount();
}

//----------------------------------------------------------------
int Pad::GetTouchCount() NN_NOEXCEPT
{
    return m_TouchCount;
}

int Pad::GetTouchAction() NN_NOEXCEPT
{
    return m_Touches.GetAction();
}
bool Pad::GetPosition( int n, int* pX, int* pY ) NN_NOEXCEPT
{
    if ( n >= m_TouchCount )
    {
        return false;
    }

    nn::hid::TouchState tst = m_Touches.GetState( n );
    if ( pX )
    {
        *pX = tst.x;
    }
    if ( pY )
    {
        *pY = tst.y;
    }
    return true;
}

//----------------------------------------------------------------
namespace {
    int g_PreAction;
    int g_Delay;
    int g_DownX;
    int g_DownY;

    bool g_IsTouchDown;
    bool g_IsReleasedEventOccurred;
    bool g_IsUpEventOccurred;
    bool g_IsDragged;

    int g_EventPositionX;
    int g_EventPositionY;
    int g_DraggedMoveX;
    int g_DraggedMoveY;
    int g_DraggedX;
    int g_DraggedY;
    float g_DraggedLength;

float distance( int x1, int y1, int x2, int y2 ) NN_NOEXCEPT
{
    uint64_t d = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    return sqrtf( d );
}

} //namespace

TouchPanel::TouchPanel( app::Pad& pad ) NN_NOEXCEPT
{
    if ( pad.GetTouchCount() > 0 )
    {
        g_IsUpEventOccurred = false;
        g_IsTouchDown = false;

        //int count = pad.GetTouchCount();
        int action = pad.GetTouchAction();
        switch( action )
        {
            case Pad::TouchAction_Down:
                if ( g_PreAction == Pad::TouchAction_None )
                {
                    g_Delay = 0;
                    g_PreAction = Pad::TouchAction_Down;
                    pad.GetPosition( 0, &g_DownX, &g_DownY );
                    g_IsDragged = false;
                    g_IsTouchDown = true;
                }
                break;
            case Pad::TouchAction_Move:
                if ( g_PreAction == Pad::TouchAction_Move || g_PreAction == Pad::TouchAction_Down )
                {
                    g_PreAction = Pad::TouchAction_Move;
                    g_Delay ++;

                    int x, y;
                    pad.GetPosition( 0, &x, &y );
                    float len = distance( g_DownX, g_DownY, x, y );
                    if ( len > 20.0F || g_IsDragged )
                    {
                        g_IsDragged = true;
                        g_DraggedMoveX = x;
                        g_DraggedMoveY = y;
                        g_DraggedX = x - g_DownX;
                        g_DraggedY = y - g_DownY;
                        g_DraggedLength = len;
                    }
                }
                else
                {
                    g_Delay = 0;
                }
                break;
            case Pad::TouchAction_Up:
                if ( g_Delay < 5 )
                {
                    // 余りに短い場合はなにもしない
                }
                else
                {
                    int x, y;
                    pad.GetPosition( 0, &x, &y );
                    g_EventPositionX = x;
                    g_EventPositionY = y;
                    g_IsReleasedEventOccurred = true;
                    if ( distance( g_DownX, g_DownY, x, y ) < 10.0F )
                    {
                        g_IsUpEventOccurred = true;
                    }
                }
                break;
            default:
                break;
        }
    }
    else
    {
        g_PreAction = Pad::TouchAction_None;
        g_Delay = 0;
        g_IsTouchDown = false;
        g_IsDragged = false;
        g_IsReleasedEventOccurred = false;
        g_IsUpEventOccurred = false;
    }
}

void TouchPanel::Clear() NN_NOEXCEPT
{
    g_PreAction = Pad::TouchAction_None;
    g_Delay = 0;
    g_IsUpEventOccurred = false;
}

bool IsTouchDown() NN_NOEXCEPT
{
    return g_IsTouchDown;
}

bool IsTouchKeepDown() NN_NOEXCEPT
{
    return ( g_PreAction == Pad::TouchAction_Move || g_PreAction == Pad::TouchAction_Down );
}

void TouchPanel::GetDownPosition( int* pX, int* pY ) NN_NOEXCEPT
{
    if ( pX )
    {
        *pX = g_DownX;
    }
    if ( pY )
    {
        *pY = g_DownY;
    }
}

bool TouchPanel::IsTouchReleased() NN_NOEXCEPT
{
    return g_IsReleasedEventOccurred;
}
bool TouchPanel::IsTouchUp() NN_NOEXCEPT
{
    return g_IsUpEventOccurred;
}
void TouchPanel::GetUpPosition( int* pX, int* pY ) NN_NOEXCEPT
{
    if ( pX )
    {
        *pX = g_EventPositionX;
    }
    if ( pY )
    {
        *pY = g_EventPositionY;
    }
}

bool TouchPanel::IsDragged() NN_NOEXCEPT
{
    return g_IsDragged;
}
void TouchPanel::GetDraggedMove( int* pX, int* pY ) NN_NOEXCEPT
{
    if ( pX )
    {
        *pX = g_DraggedMoveX;
    }
    if ( pY )
    {
        *pY = g_DraggedMoveY;
    }
}
void TouchPanel::GetDraggedPosition( int* pX, int* pY ) NN_NOEXCEPT
{
    if ( pX )
    {
        *pX = g_DraggedX;
    }
    if ( pY )
    {
        *pY = g_DraggedY;
    }
}
void TouchPanel::GetDraggedOrigin( int* pX, int* pY ) NN_NOEXCEPT
{
    if ( pX )
    {
        *pX = g_DownX;
    }
    if ( pY )
    {
        *pY = g_DownY;
    }
}
void TouchPanel::GetDraggedLength( float *pLength ) NN_NOEXCEPT
{
    if ( pLength )
    {
        *pLength = g_DraggedLength;
    }
}

} //namespace app
