﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>

namespace app
{
    enum TextResource
    {
        TextResource_TopMenuTitle = 0,
        TextResource_ListApplications,
        TextResource_UnmountStorage,
        TextResource_DisconnectNetwork,
        TextResource_ConnectNetwork,
        TextResource_ViewPushNotificationLog,
        TextResource_StartSubscribing,
        TextResource_OtherMenu,

        TextResource_OtherMenuTitle,
        TextResource_CancelUserSelect,
        TextResource_CancelUserSelectDone,
        TextResource_SwitchLanguage,
        TextResource_BackFromOtherMenu,

        TextResource_ConnectingNetwork,
        TextResource_PushButtonBToAbort,
        TextResource_Connected,
        TextResource_PushButtonA,
        TextResource_Disconnecting,
        TextResource_Disconnected,
        TextResource_FailedConnectNetwork,

        TextResource_SortLogTitle,
        TextResource_SortByApp,
        TextResource_SortByAppCurrent,
        TextResource_SortByNo,
        TextResource_SortByNoCurrent,

        TextResource_AppListInvalidDirName,
        TextResource_AppListFailedMount,

        TextResource_SortAppListTitle,
        TextResource_SortAppListByApp,
        TextResource_SortAppListByAppCurrent,
        TextResource_SortAppListByBgTask,
        TextResource_SortAppListByBgTaskCurrent,

        TextResource_AppMenuTitle,
        TextResource_ListDirectories,
        TextResource_RequestToSync,
        TextResource_CancelSyncRequest,
        TextResource_UnregisterBgTask,
        TextResource_DumpToSdCard,
        TextResource_ClearStorage,

        TextResource_ConfirmRequestToSync,
        TextResource_ConfirmCancelSyncRequest,
        TextResource_ConfirmUnregisterBgTask,
        TextResource_ConfirmDumpToSdCard,
        TextResource_ConfirmClearStorage,

        TextResource_SdCardDir1,
        TextResource_SdCardDir2,

        TextResource_FailedToEnumerateFiles,
        TextResource_SdDirectoryNameGuide,
        TextResource_FileNameGuide,
        TextResource_SavingToSdCard,
        TextResource_SavingToSaveData,
        TextResource_DirectoryNameGuide,
        TextResource_AllDataSavingDone,

        TextResource_FilesSaved,
        TextResource_FilesSkippedBig,
        TextResource_FilesSkippedNotModiry,
        TextResource_FilesSaveError,
        TextResource_DirsCreated,
        TextResource_DirsCreateError,
        TextResource_SaveAllAndButtonA,

        TextResource_LowSaveDataSpace,
        TextResource_FailedCreateSaveData,
        TextResource_FailedMountSaveData,
        TextResource_FailedCreateDirectory,
        TextResource_CreatedDirectory,
        TextResource_FailedCreateFile,
        TextResource_FailedOpenFile,
        TextResource_FailedCalculateFileHash,
        TextResource_SkipBecauseNotModified,
        TextResource_ErrorOccurredInReadDeliveryCache,
        TextResource_ErrorOccurredInWritingSaveData,
        TextResource_CopyDone,
        TextResource_SkipBecauseTooBig,
        TextResource_ErrorOccurred,
        TextResource_FailedReadDeliveryCache,
        TextResource_LowSdCardSpace,
        TextResource_ConfirmSdCard,

        TextResource_HelpTopMenu,
        TextResource_HelpAppList,
        TextResource_HelpAppListInputStr,
        TextResource_HelpAppListSubMenu,
        TextResource_HelpSaveApplicationMenu,
        TextResource_HelpBinaryDump,
        TextResource_HelpBinaryDumpDetailMenu,
        TextResource_HelpFileMenu,
        TextResource_HelpFileMenuDir,
        TextResource_HelpNetworkConnection,
        TextResource_HelpOtherMenu,
        TextResource_HelpPushNotificationLogMenu,
        TextResource_HelpPushNotificationLogMenuSubMenu,
        TextResource_HelpSaveAllFile,
        TextResource_HelpSaveAllFileFinished,

        TextResource_ArrayMax
    };

    const char16_t* GetText( int index ) NN_NOEXCEPT;
}
