﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BcatSystemDebugTool_Common.h"
#include <nn/bcat/bcat_DeliveryCacheDirectory.h>
#include <nn/bcat/bcat_DeliveryCacheFile.h>
#include <nn/crypto/crypto_Md5Generator.h>

namespace app
{
enum SyncFileResult
{
    SyncFileResult_Copied = 0,
    SyncFileResult_SizeSkipped,
    SyncFileResult_HashSkipped,
    SyncFileResult_ErrorOccurred,
    SyncFileResult_OnlyCreateDirectory
};
enum SyncFileError
{
    SyncFileError_MountSaveData,             // セーブデータのマウントに失敗
    SyncFileError_SyncSaveDataDirectory,     // セーブデータのディレクトリ同期に失敗
    SyncFileError_CreateSaveDataFile,        // セーブデータのファイル作成に失敗
    SyncFileError_OpenSaveDataFile,          // セーブデータの読みだし用ファイルオープンに失敗
    SyncFileError_HashSaveDataFile,          // セーブデータのハッシュ計算に失敗
    SyncFileError_OpenSaveDataFileForWrite,  // セーブデータの書き込み用ファイルオープンに失敗
    SyncFileError_OpenDeliveryCacheFile,     // データ配信キャッシュファイルのオープンに失敗
    SyncFileError_ReadDeliveryCacheFile,     // データ配信キャッシュファイルの読み込みに失敗
    SyncFileError_WriteSaveDataFile,         // セーブデータの書き込み用に失敗
    SyncFileError_MountSdCard,               // SD カードのマウントに失敗
    SyncFileError_SyncSdCardDirectory,       // SD カードのディレクトリ同期に失敗
    SyncFileError_CreateSdCardFile,          // SD カードのファイル作成に失敗
    SyncFileError_OpenSdCardFile,            // SD カードのファイルオープンに失敗
    SyncFileError_WriteSdCardFile,           // SD カードのファイル書き込みに失敗
};

void SetConsoleForProcessFileSystem( app::ScrollConsole<char16_t>* p ) NN_NOEXCEPT;
void PrintDirectoryToConsole( nn::bcat::DirectoryName* pDirName, int attr, bool isLastSlash, bool isCr  ) NN_NOEXCEPT;
void PrintEntryToConsole( nn::bcat::DirectoryName* pDirName, nn::bcat::DeliveryCacheDirectoryEntry* pEntry, int attr, bool isCr  ) NN_NOEXCEPT;


nn::Result SyncDirectorySd( nn::bcat::DirectoryName* pDirName, const char* rootDirName, bool* isDirectoryCreated ) NN_NOEXCEPT;
SyncFileResult SyncFileToSaveData( nn::bcat::DirectoryName* pDirName, nn::bcat::DeliveryCacheDirectoryEntry* pEntry, bool isHashCompare, int* pCreateDirCount ) NN_NOEXCEPT;
SyncFileResult SyncFileToSdCard( nn::bcat::DirectoryName* pDirName, nn::bcat::DeliveryCacheDirectoryEntry* pEntry, bool isHashCompare, int* pCreateDirCount ) NN_NOEXCEPT;

nn::Result GetLastSyncFileResult() NN_NOEXCEPT;
SyncFileError GetLastSyncFileError() NN_NOEXCEPT;
void SetRootDirectoryName( const char* dirName );
}
