﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#define _USE_MATH_DEFINES
#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <glv/glv_Log.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_util.h>

#include <nn/bcat/bcat_Result.h>
#include <nn/bcat/detail/bcat_TypesDetail.h>
#include <nn/bcat/bcat_Api.h>
#include <nn/bcat/bcat_ApiAdmin.h>

#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/result/result_HandlingUtility.h>

#include "Base/BcatTestApp_ConsoleCore.h"
#include "Base/BcatTestApp_Sequence.h"
#include "Base/BcatTestApp_Glv.h"
#include "Base/BcatTestApp_Hid.h"
#include "Base/BcatTestApp_Utility.h"

#include "Common/BcatTestApp_Account.h"
#include "Common/BcatTestApp_BaseDisplay.h"
#include "Common/BcatTestApp_Config.h"
#include "Common/BcatTestApp_Console.h"
#include "Common/BcatTestApp_Dialog.h"
#include "Common/BcatTestApp_DialogUtility.h"
#include "Common/BcatTestApp_InputString.h"
#include "Common/BcatTestApp_Menu.h"

#include "BcatSystemDebugTool_Defines.h"
#include "BcatSystemDebugTool_ApplicationDefines.h"
#include "BcatSystemDebugTool_TextResources.h"
