﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include<string>
#include <nn/util/util_StringView.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/audio/audio_Profiler.h>

namespace{

const char HelpMessage[] =
    "usage: AudioProcessDebugCommand <command> [<args>]\n"
    "\n"
    "The AudioProcessDebugCommand commands are:\n"
    "   --start-cpu-profiler Start CPU profiler\n"
    "   --stop-cpu-profiler  Stop CPU profiler\n"
    "   --help               Show this message\n";

void StartCpuProfiler() NN_NOEXCEPT
{
    nn::audio::StartCpuProfiler();
}

void StopCpuProfiler() NN_NOEXCEPT
{
    nn::audio::StopCpuProfiler();
}

} // anonymous namespace

extern "C" void nnMain()
{
    const auto argc = nn::os::GetHostArgc();
    const auto argv = nn::os::GetHostArgv();

    if(argc < 2)
    {
        NN_LOG(HelpMessage);
        return;
    }

    if(argv[1])
    {
        const auto command = nn::util::string_view(argv[1]);

        if(command == "--start-cpu-profiler")
        {
            StartCpuProfiler();
        }
        else if(command == "--stop-cpu-profiler")
        {
            StopCpuProfiler();
        }
        else if(command == "--help")
        {
            NN_LOG(HelpMessage);
        }
        else
        {
            NN_LOG("Command %s is not an AudioProcessDebugCommand. See AudioProcessDebugCommand --help\n", command);
        }
    }
}
