﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include "AlbumFileMaker_Log.h"

namespace nn{ namespace album{

    struct ProgramOption
    {
        nn::util::optional<std::string> action;
        nn::util::optional<std::string> inputPath;
        nn::util::optional<std::string> outputPath;
        nn::util::optional<std::string> makerNotePath;
    };

    bool ParseProgramOption(ProgramOption* pOutValue, int argc, char** argv) NN_NOEXCEPT;

}}

#define NN_ALBUM_CHECK_OPTION_IMPL(var, name, failureValue)  \
    if(!var)                    \
    {                           \
        NN_ALBUM_LOG_ERR("'%s' is required\n", name);   \
        return failureValue;    \
    }

#define NN_ALBUM_CHECK_OPTION_ACTION(opts, failureValue)     NN_ALBUM_CHECK_OPTION_IMPL(opts.action, "--action", failureValue)
#define NN_ALBUM_CHECK_OPTION_INPUTPATH(opts, failureValue)  NN_ALBUM_CHECK_OPTION_IMPL(opts.inputPath, "--input-path", failureValue)
#define NN_ALBUM_CHECK_OPTION_OUTPUTPATH(opts, failureValue) NN_ALBUM_CHECK_OPTION_IMPL(opts.outputPath, "--output-path", failureValue)
#define NN_ALBUM_CHECK_OPTION_MAKERNOTEPATH(opts, failureValue) NN_ALBUM_CHECK_OPTION_IMPL(opts.makerNotePath, "--makernote-path", failureValue)

