﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/os/os_Argument.h>

#include "AlbumFileMaker_ProgramOption.h"
#include "AlbumFileMaker_ExtractScreenShotMakerNote.h"
#include "AlbumFileMaker_ReplaceScreenShotMakerNote.h"

extern "C" void nnMain() NN_NOEXCEPT
{
    int argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();

    nn::album::ProgramOption opts = {};

    if(!nn::album::ParseProgramOption(&opts, argc - 1, argv + 1))
    {
        return;
    }

    NN_ALBUM_CHECK_OPTION_ACTION(opts, void());

    if(*opts.action == "extract-makernote")
    {
        nn::album::ExtractScreenShotMakerNote(opts);
    }
    else if(*opts.action == "replace-makernote")
    {
        nn::album::ReplaceScreenShotMakerNote(opts);
    }
    else
    {
        NN_ALBUM_LOG_ERR("unknown action '%s'\n", opts.action->c_str());
    }

    return;
}
