﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifdef NN_GFX_VULKAN
#define gl_VertexID gl_VertexIndex
#define GFXUTIL_LAYOUT_LOCATION( x ) layout( location = x )
#else
in int gl_VertexID;
#define GFXUTIL_LAYOUT_LOCATION( x )
#endif


GFXUTIL_LAYOUT_LOCATION( 0 ) out vec2 vTexCoord;
GFXUTIL_LAYOUT_LOCATION( 1 ) out flat int layer;
GFXUTIL_LAYOUT_LOCATION( 2 ) out flat int mipLevel;

void main()
{
    float x = (gl_VertexID & 1) * -2.0 + 1.0;
    float y = (gl_VertexID & 2) * -1.0 + 1.0;

    gl_Position = vec4(x,y,.0,1.0);
    vTexCoord = ( vec2(x,y) + vec2(1.0, 1.0) ) * .5;

    int texInfo = (gl_VertexID >> 2);
    mipLevel = texInfo >> 16;
    layer = texInfo ^ (mipLevel << 16);
}
