﻿/*---------------------------------------------------------------------------*
  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

#ifdef NN_GFX_VULKAN
#define GFXUTIL_LAYOUT_LOCATION( x ) layout( location = x )
#define GFXUTIL_LAYOUT_BINDING( x ) layout( binding = x )
#define GFXUTIL_BINDING( x ) binding = x,
#else
#define GFXUTIL_LAYOUT_LOCATION( x )
#define GFXUTIL_LAYOUT_BINDING( x )
#define GFXUTIL_BINDING( x )
#endif

GFXUTIL_LAYOUT_BINDING( 1 ) uniform sampler2D uTextureSrc;
layout(GFXUTIL_BINDING( 0 ) std140) uniform ShaderParam
{
    mat4 uUser;
    float uAlpha;
};

layout(location = 0) in vec4 vColor;
layout(location = 1) in vec4 vTexCoord;

layout(location = 0) out vec4 oColor;

void main(void)
{
    vec4 textureColor = texture(uTextureSrc, vTexCoord.xy);

    oColor = textureColor * vColor;
    oColor.a *= uAlpha;
}
