﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>

namespace nn { namespace manu {

class HostFileIoServer
{
public:
    static const int WorkThreadCount = 2;

    void Initialize(void* pStack, size_t stackSize) NN_NOEXCEPT;
    void Run() NN_NOEXCEPT;

private:
    const int UfioInterfaceNumber = 1;
    const int UsbTransferInterfaceNumber = 2;

    os::ThreadType serverThread[WorkThreadCount];

    static void RunThread(void* arg) NN_NOEXCEPT;
    void MainLoop() NN_NOEXCEPT;
};

}}
