﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Thread.h>
#include <nn/nn_TimeSpan.h>
#include <nn/manu/manu_UfioRequestHipcServer.h>
#include <nn/manu/server/manu_ServerApi.h>

#include "manu_HostFileServer.h"

#include <memory>
#include <string>

namespace nn { namespace manu {

void HostFileIoServer::RunThread(void* arg) NN_NOEXCEPT
{
    reinterpret_cast<HostFileIoServer*>(arg)->MainLoop();
}

void HostFileIoServer::MainLoop() NN_NOEXCEPT
{
    nn::manu::LoopUfioRequestServer();
}

void HostFileIoServer::Initialize(void* pStack, size_t stackSize) NN_NOEXCEPT
{
    nn::manu::server::InitializeForUfio(HostFileIoServer::UfioInterfaceNumber);
    nn::manu::server::InitializeForUsbTransfer(HostFileIoServer::UsbTransferInterfaceNumber);
    nn::manu::InitializeUfioRequestServer();

    for(int i=0; i<HostFileIoServer::WorkThreadCount; i++)
    {
        uint8_t* threadStackPointer = reinterpret_cast<uint8_t*>(pStack) + stackSize * i;
        auto pThread = &(this->serverThread[i]);

        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(pThread, RunThread, this, threadStackPointer, stackSize, nn::os::DefaultThreadPriority));
    }
}

void HostFileIoServer::Run() NN_NOEXCEPT
{
    for(int i=0; i<HostFileIoServer::WorkThreadCount; i++)
    {
        nn::os::StartThread(&(this->serverThread[i]));
    }
}


}}
