﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_InitializeFileSystem.h"

#include <type_traits>
#include <nn/nn_SdkAssert.h>
#include <nn/fs.h>
#include <nn/fs/fs_ResultHandler.h>
#include <nn/lmem/lmem_ExpHeap.h>

namespace {

    static const size_t FileSystemMemorySize = 4 * 1024;

    std::aligned_storage<FileSystemMemorySize, 4 * 1024>::type g_FileSystemHeapMemory;
    nn::lmem::HeapHandle g_hFileSystemHeap;

    void* AllocateFileSystemMemory(size_t size) NN_NOEXCEPT
    {
        void* p = nn::lmem::AllocateFromExpHeap(g_hFileSystemHeap, size);
        NN_SDK_ASSERT_NOT_NULL(p);
        return p;
    }

    void FreeFileSystemMemory(void* p, size_t) NN_NOEXCEPT
    {
        nn::lmem::FreeToExpHeap(g_hFileSystemHeap, p);
    }
}

namespace nn{ namespace capsrv{

    void InitializeFileSystem() NN_NOEXCEPT
    {
        g_hFileSystemHeap = nn::lmem::CreateExpHeap(&g_FileSystemHeapMemory, sizeof(g_FileSystemHeapMemory), nn::lmem::CreationOption_ThreadSafe);
        NN_SDK_ASSERT_NOT_NULL(g_hFileSystemHeap);

        nn::fs::SetAllocator(AllocateFileSystemMemory, FreeFileSystemMemory);
        // FS のエラー発生時の自動アボートを無効化
        nn::fs::SetEnabledAutoAbort(false);
    }

    void FinalizeFileSystem() NN_NOEXCEPT
    {
        nn::lmem::DestroyExpHeap(g_hFileSystemHeap);
    }

}}
