﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

class Processor
{
public:
    enum Status
    {
        Status_NotStarted,
        Status_Processing,
        Status_Success,
        Status_Failure,
        Status_Skipped,
    };

    enum Stage
    {
        Stage_ProcessEula,
        Stage_ProcessWifi,
        Stage_ProcessServiceDiscovery,
        Stage_ProcessAccount,
        Stage_Count,
    };

    static const char* GetStatusText(Status status)
    {
        switch(status)
        {
        case Status_NotStarted:
            return "NotStarted";
        case Status_Processing:
            return "Processing";
        case Status_Success:
            return "Success";
        case Status_Failure:
            return "Failure";
        case Status_Skipped:
            return "Skipped";
        default:
            NN_UNEXPECTED_DEFAULT;
        }
    }

    static const char* GetStageText(Stage stage)
    {
        switch(stage)
        {
        case Stage_ProcessEula:
            return "Eula";
        case Stage_ProcessWifi:
            return "Wifi";
        case Stage_ProcessServiceDiscovery:
            return "ServiceDiscovery";
        case Stage_ProcessAccount:
            return "Account";
        default:
            NN_UNEXPECTED_DEFAULT;
        }
    }

    Processor()
    {
        for (int i = 0; i < Stage_Count; i++)
        {
            m_Status[i] = Status_NotStarted;
        }
    };

    void Process();

    Status GetStatus(Stage stage)
    {
        return m_Status[stage];
    }

private:
    Status m_Status[Stage_Count];

    void SetStatus(Stage stage, Status status)
    {
        NN_LOG("[DummyStarter %s] %s: %s\n", __FUNCTION__, GetStageText(stage), GetStatusText(status));
        m_Status[stage] = status;
    }

    bool ProcessEula();
    bool ProcessWifi();
    bool ProcessServiceDiscovery();
    bool ProcessAccount();
};
