﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_OfflineShowArgPlayReport.h>

#include <nn/web/common/web_CommonArgData.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(
    const char* pDocumentPath) NN_NOEXCEPT
: ShowOfflineHtmlPageArg(pDocumentPath)
{
    // デフォルトはプレイレポートを利用する
    SetPlayReportEnabled(true);
}

//------------------------------------------------------------------------
ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(
    const nn::ApplicationId& id,
    const char* pDocumentPath) NN_NOEXCEPT
: ShowOfflineHtmlPageArg(id, pDocumentPath)
{
    // デフォルトはプレイレポートを利用する
    SetPlayReportEnabled(true);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArgWithPlayReport::SetPlayReportEnabled(const bool playReportEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PlayReportJsExtensionEnabled, playReportEnabled);
}

}} // namespace nn::web
