﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_OfflineShowArg.h>

#include <string>

#include <nn/applet/applet_Types.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_OfflineApiDetail.h>
#include <nn/web/detail/web_OfflineTypesDetail.h>

namespace nn { namespace web {

// enum値一致のチェック
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_EndButtonPressed) == static_cast<int>(web::common::ExitReason::EndButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_BackButtonPressed) == static_cast<int>(web::common::ExitReason::BackButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_ExitMessage) == static_cast<int>(web::common::ExitReason::ExitMessage));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_CallbackUrlReached) == static_cast<int>(web::common::ExitReason::CallbackUrlReached));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_LastWindowDeleted) == static_cast<int>(web::common::ExitReason::LastWindowDeleted));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_LocalNetworkDisconnectionDenied) == static_cast<int>(web::common::ExitReason::LocalNetworkDisconnectionDenied));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_MediaPlayerClosed) == static_cast<int>(web::common::ExitReason::MediaPlayerClosed));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_CausedByWebPage) == static_cast<int>(web::common::ExitReason::CausedByWebPage));
NN_STATIC_ASSERT(static_cast<int>(OfflineExitReason_Unexpected) == static_cast<int>(web::common::ExitReason::Unexpected));

//------------------------------------------------------------------------
ShowOfflineHtmlPageArg::ShowOfflineHtmlPageArg() NN_NOEXCEPT
: m_Data()
{
    // 初期化
    common::CommonArgData::InitializeData(m_Data, common::ShimKind::Offline);

    // 左スティックモードを空間ナビへ変更する
    // refs; BROWSER1-550
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode::SpatialNavi);

    // ページ情報無効化
    // refs: BROWSER1-556
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UsePageInfo, false);

    // デフォルトはポインター有効
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseStickPointer, true);

    // コンテンツ欠落を禁止する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsContentsDropDisabled, true);

    // 再起動ダイアログを抑制する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // ブラックリスト以外のURLは許可する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::DenyOnlyBlacklistedURL, true);
}

//------------------------------------------------------------------------
ShowOfflineHtmlPageArg::ShowOfflineHtmlPageArg(
    const char* pDocumentPath) NN_NOEXCEPT
: ShowOfflineHtmlPageArg()
{
    // 遊び方用ドキュメントを設定
    detail::ShowOfflinePageArgDetail::SetDocumentKind(m_Data, detail::OfflineDocumentKind::ApplicationHtmlDocument);

    // idは0とする
    const nn::ApplicationId defaultId = { 0x0 };

    // ApplicationIdを設定
    detail::ShowOfflinePageArgDetail::SetApplicationId(m_Data, defaultId);

    // DocumentPathを設定
    detail::ShowOfflinePageArgDetail::SetDocumentPath(m_Data, DocumentPathMaxLength, pDocumentPath);
}

//------------------------------------------------------------------------
ShowOfflineHtmlPageArg::ShowOfflineHtmlPageArg(
    const nn::ApplicationId& id,
    const char* pDocumentPath) NN_NOEXCEPT
: ShowOfflineHtmlPageArg()
{
    // 遊び方用ドキュメントを設定
    detail::ShowOfflinePageArgDetail::SetDocumentKind(m_Data, detail::OfflineDocumentKind::ApplicationHtmlDocument);

    // 引数のidは使わずidは0とする
    const nn::ApplicationId defaultId = { 0x0 };

    // ApplicationIdを設定
    detail::ShowOfflinePageArgDetail::SetApplicationId(m_Data, defaultId);

    // DocumentPathを設定
    detail::ShowOfflinePageArgDetail::SetDocumentPath(m_Data, DocumentPathMaxLength, pDocumentPath);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetBootAsMediaPlayer(bool bootAsMediaPlayer) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootAsMediaPlayer, bootAsMediaPlayer);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetPointerEnabled(const bool pointerEnabled) NN_NOEXCEPT
{
    detail::ShowOfflinePageArgDetail::SetPointerEnabled(m_Data, pointerEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetLeftStickMode(
    const OfflineLeftStickMode& mode) NN_NOEXCEPT
{
    detail::ShowOfflinePageArgDetail::SetLeftStickMode(m_Data, mode);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetFooterEnabled(const bool footerEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::FooterEnabled, footerEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetFooterFixedKind(const OfflineFooterFixedKind offlineFooterFixedKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::FooterFixedKind, common::FooterFixedKind(offlineFooterFixedKind));
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetBackgroundKind(
    const OfflineBackgroundKind& backgroundKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BackgroundKind, common::BackgroundKind(backgroundKind));
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetBootDisplayKind(
    const OfflineBootDisplayKind bootDisplayKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind(bootDisplayKind));
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetKeyRepeatFrame(
    int delayFrame, int pulseFrame) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::KeyRepeatDelayFrame, delayFrame);
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::KeyRepeatPulseFrame, pulseFrame);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetJsExtensionEnabled(const bool jsExtensionEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::GeneralJsExtensionEnabled, jsExtensionEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetTouchEnabledOnContents(const bool touchEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::TouchEnabledOnContents, touchEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetMediaPlayerAutoCloseEnabled(const bool autoCloseEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerAutoCloseEnabled, autoCloseEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetPageCacheEnabled(const bool pageCacheEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PageCacheEnabled, pageCacheEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetPageFadeEnabled(const bool pageFadeEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PageFadeEnabled, pageFadeEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetWebAudioEnabled(const bool webAudioEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::WebAudioEnabled, webAudioEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetBootLoadingIconEnabled(const bool bootLoadingIconEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootLoadingIconEnabled, bootLoadingIconEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetPageScrollIndicatorEnabled(const bool pageScrollIndicatorEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PageScrollIndicatorEnabled, pageScrollIndicatorEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetMediaPlayerSpeedControlEnabled(const bool mediaPlayerSpeedControlEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerSpeedControlEnabled, mediaPlayerSpeedControlEnabled);
}

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArg::SetMediaAutoPlayEnabled(bool autoPlayEnabled) NN_NOEXCEPT
{
    // 自動再生を可能としている場合、自動再生抑制を無効化するため、フラグを反転させる
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerUserGestureRestrictionEnabled, !autoPlayEnabled);
}

//------------------------------------------------------------------------
OfflineHtmlPageReturnValue::OfflineHtmlPageReturnValue() NN_NOEXCEPT
: m_ExitReason()
, m_LastUrl()
, m_LastUrlSize()
{
}

//------------------------------------------------------------------------
OfflineExitReason OfflineHtmlPageReturnValue::GetOfflineExitReason() const NN_NOEXCEPT
{
    return static_cast<OfflineExitReason>(m_ExitReason);
}

//------------------------------------------------------------------------
const char* OfflineHtmlPageReturnValue::GetLastUrl() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == OfflineExitReason_CallbackUrlReached);
    return m_LastUrl;
}

//------------------------------------------------------------------------
size_t OfflineHtmlPageReturnValue::GetLastUrlSize() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == OfflineExitReason_CallbackUrlReached);
    return size_t(m_LastUrlSize);
}

}} // namespace nn::web
