﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_LobbyShowArgPrivate.h>

#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_LobbyApiDetail.h>

namespace nn { namespace web {

// enum値一致のチェック
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_EndButtonPressed) == static_cast<int>(web::common::ExitReason::EndButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_BackButtonPressed) == static_cast<int>(web::common::ExitReason::BackButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_ExitMessage) == static_cast<int>(web::common::ExitReason::ExitMessage));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_CallbackUrlReached) == static_cast<int>(web::common::ExitReason::CallbackUrlReached));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_LastWindowDeleted) == static_cast<int>(web::common::ExitReason::LastWindowDeleted));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_LocalNetworkDisconnectionDenied) == static_cast<int>(web::common::ExitReason::LocalNetworkDisconnectionDenied));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_MediaPlayerClosed) == static_cast<int>(web::common::ExitReason::MediaPlayerClosed));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_CausedByWebPage) == static_cast<int>(web::common::ExitReason::CausedByWebPage));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_UserSelectionCanceled) == static_cast<int>(web::common::ExitReason::UserSelectionCanceled));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_NetworkConnectionFailed) == static_cast<int>(web::common::ExitReason::NetworkConnectionFailed));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_SystemUpdateRequired) == static_cast<int>(web::common::ExitReason::SystemUpdateRequired));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_IllegalArgument) == static_cast<int>(web::common::ExitReason::IllegalArgument));
NN_STATIC_ASSERT(static_cast<int>(LobbyExitReason_Unexpected) == static_cast<int>(web::common::ExitReason::Unexpected));

//------------------------------------------------------------------------
ShowLobbyPageArg::ShowLobbyPageArg() NN_NOEXCEPT
: m_Data()
{
    nn::web::common::CommonArgData::InitializeData(m_Data, nn::web::common::ShimKind::Lobby);

    // refs; BROWSER1APPS-296

    // 左スティックモードを空間ナビへ変更する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode::SpatialNavi);

    // ポインターを無効化する
    // refs: BROWSER1APPS-481
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseStickPointer, false);

    // Uidを無効値にする
    SetUid(nn::account::InvalidUid);

    // コンテンツ欠落を禁止する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsContentsDropDisabled, true);

    // 再起動ダイアログを抑制する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // 起動画面を呼び出し元画像(ぼかし)にする
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind::CallerCaptureBlur);

    // 背景を呼び出し元画像(ぼかし)にする
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BackgroundKind, common::BackgroundKind::ApplicationCaptureBlur);

    // ページ情報無効化
    // refs: BROWSER1-556
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UsePageInfo, false);
}

//------------------------------------------------------------------------
void ShowLobbyPageArg::SetUid(const nn::account::Uid& uid) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::Uid, uid);
}

//------------------------------------------------------------------------
void ShowLobbyPageArg::SetLobbyParameter(const char* pLobbyParameter) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LobbyParameter, LobbyParameterMaxLength, pLobbyParameter);
}

//------------------------------------------------------------------------
LobbyPageReturnValue::LobbyPageReturnValue() NN_NOEXCEPT
: m_ExitReason()
, m_LastUrl()
, m_LastUrlSize()
{
}

//------------------------------------------------------------------------
LobbyExitReason LobbyPageReturnValue::GetLobbyExitReason() const NN_NOEXCEPT
{
    return static_cast<LobbyExitReason>(m_ExitReason);
}

//------------------------------------------------------------------------
const char* LobbyPageReturnValue::GetLastUrl() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == LobbyExitReason_CallbackUrlReached);
    return m_LastUrl;
}

//------------------------------------------------------------------------
size_t LobbyPageReturnValue::GetLastUrlSize() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == LobbyExitReason_CallbackUrlReached);
    return size_t(m_LastUrlSize);
}

}} // namespace nn::web
