﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_SdCardApi.h>
#include <nn/rid/rid_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace rid {

    Result CheckSdCard() NN_NOEXCEPT
    {
        NN_RESULT_TRY(ns::CheckSdCardMountStatus())
            NN_RESULT_CATCH(ns::ResultSdCardNotInserted) { NN_RESULT_THROW(ResultSdCardNotInserted()); }
            NN_RESULT_CATCH(ns::ResultSdCardNotMounted) { NN_RESULT_THROW(ResultSdCardNotMounted()); }
            NN_RESULT_CATCH(ns::ResultSdCardNeedsSystemUpdate) { NN_RESULT_THROW(ResultSdCardNeedsSystemUpdate()); }
            NN_RESULT_CATCH(ns::ResultSdCardNoOwnership) { NN_RESULT_THROW(ResultSdCardNoOwnership()); }
            NN_RESULT_CATCH(ns::ResultSdCardDatabaseCorrupted) { NN_RESULT_THROW(ResultSdCardDatabaseCorrupted()); }
            NN_RESULT_CATCH(ns::ResultSdCardFileSystemCorrupted) { NN_RESULT_THROW(ResultSdCardFileSystemCorrupted()); }
        NN_RESULT_END_TRY;

        NN_RESULT_SUCCESS;
    }
}}
