﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/repair.h>
#include <string>

namespace nn { namespace repair { namespace detail {

//!< メッセージ表示を扱うクラスです。
class MessageReporter final
{
private:
    //!< メッセージ表示用のコールバック
    ReportCallbackStruct m_reportCallback;

public:
    MessageReporter() NN_NOEXCEPT
    {
        const ReportCallbackStruct zeroCallback = {nullptr,nullptr,nullptr,nullptr,nullptr,nullptr};
        m_reportCallback = zeroCallback;
    }

    //!< メッセージ表示用のコールバックを登録します。
    void Register(const ReportCallbackStruct* pCallback) NN_NOEXCEPT;

    //!< メッセージ表示用のコールバックを解除します。
    void Unregister() NN_NOEXCEPT;

    //!< メッセージを送信します。
    void Send(const char* message) NN_NOEXCEPT;

    //!< メッセージを画面送信します。
    void SendScreen(const char* message) NN_NOEXCEPT;

    //!< メッセージをコンソールに送信します。
    void SendConsole(const char* message) NN_NOEXCEPT;
};

//!< コールバックを登録します。
void RegisterReportCallBack(const ReportCallbackStruct* pCallback) NN_NOEXCEPT;

//!< コールバックを解除します。
void UnregisterReportCallBack() NN_NOEXCEPT;

//!< メッセージを送信します。
void SendMessage(const char* pFormat, ...) NN_NOEXCEPT;

//!< メッセージを送信します。
void SendMessageToScreen(const char* pFormat, ...) NN_NOEXCEPT;

//!< メッセージを送信します。
void SendMessageToConsole(const char* pFormat, ...) NN_NOEXCEPT;

}}} // namespace nn::repair::detail

