﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/repair.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/factory/settings_DeviceCertificate.h>
#include "repair_DeviceId.h"

namespace nn { namespace repair { namespace detail {

namespace
{
    struct Signature
    {
        Bit32       type;
        Bit8        data[60];
        Bit8        padding[64];
    };

    struct DeviceName
    {
        char    prefix[2];
        char    id[16];
        char    delimiter;
        char    variation;
        char    padding[44];
    };

    struct EciDeviceCertificate
    {
        Signature   signature;
        char        publisher[64];
        Bit32       publicKeyType;
        DeviceName  name;
        Bit32       expirationDate;
        Bit8        publicKey[60];
        Bit8        padding[60];
    };
}

nn::Result DeviceId::GetValue(char* pOutValue) const NN_NOEXCEPT
{
    EciDeviceCertificate cert;
    NN_RESULT_DO(
            nn::settings::factory::GetEciDeviceCertificate(
                reinterpret_cast<nn::settings::factory::EccB233DeviceCertificate*>(&cert)));
    auto id = std::stoull(cert.name.id, nullptr, 16);
    std::strncpy(pOutValue, std::to_string(id).c_str(), DeviceIdLength);

    NN_RESULT_SUCCESS;
}

nn::Result DeviceId::GetHexValue(char* pOutValue) const NN_NOEXCEPT
{
    EciDeviceCertificate cert;
    NN_RESULT_DO(
        nn::settings::factory::GetEciDeviceCertificate(
            reinterpret_cast<nn::settings::factory::EccB233DeviceCertificate*>(&cert)));

    std::strncpy(pOutValue, cert.name.id, DeviceIdHexLength);

    NN_RESULT_SUCCESS;
}


}}} // namespace nn::repair::detail
