﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d/res/g3d_ResModel.h>
#include <nw/g3d/res/g3d_ResFile.h>

NW_G3D_PRAGMA_PUSH_WARNINGS
NW_G3D_DISABLE_WARNING_SHADOW

namespace nw { namespace g3d { namespace res {

BindResult ResModel::Bind(const ResFile* pFile)
{
    NW_G3D_ASSERT_NOT_NULL(pFile);

    BindResult result;

    for (int idxMat = 0, numMat = GetMaterialCount(); idxMat < numMat; ++idxMat)
    {
        ResMaterial* pMaterial = GetMaterial(idxMat);
        result |= pMaterial->Bind(pFile);
    }

    return result;
}

BindResult ResModel::Bind(const ResFile* pFile, BindCallback* pCallback)
{
    NW_G3D_ASSERT_NOT_NULL(pFile);
    NW_G3D_ASSERT_NOT_NULL_DETAIL(pCallback, "%s\n", NW_G3D_RES_GET_NAME(this, GetName()));

    BindResult result;

    for (int idxMat = 0, numMat = GetMaterialCount(); idxMat < numMat; ++idxMat)
    {
        ResMaterial* pMaterial = GetMaterial(idxMat);
        pCallback->m_pMaterial = pMaterial;
        result |= pMaterial->Bind(pFile, pCallback);
    }
    pCallback->m_pMaterial = NULL;

    return result;
}

bool ResModel::ForceBind(const ResTexture* pTexture, const char* name)
{
    bool result = false;
    for (int idxMat = 0, numMat = GetMaterialCount(); idxMat < numMat; ++idxMat)
    {
        ResMaterial* pMaterial = GetMaterial(idxMat);
        result |= pMaterial->ForceBind(pTexture, name);
    }
    return result;
}

void ResModel::Release()
{
    for (int idxMat = 0, numMat = GetMaterialCount(); idxMat < numMat; ++idxMat)
    {
        ResMaterial* pMaterial = GetMaterial(idxMat);
        pMaterial->Release();
    }
}

void ResModel::Setup()
{
    int numMaterial = this->GetMaterialCount();
    for (int i = 0; i < numMaterial; ++i)
    {
        this->GetMaterial(i)->Setup();
    }

    int numShape = this->GetShapeCount();
    for (int i = 0; i < numShape; ++i)
    {
        this->GetShape(i)->Setup();
    }

    int numVertex = this->GetVertexCount();
    for (int i = 0; i < numVertex; ++i)
    {
        this->GetVertex(i)->Setup();
    }
}

void ResModel::Cleanup()
{
    int numMaterial = this->GetMaterialCount();
    for (int i = 0; i < numMaterial; ++i)
    {
        this->GetMaterial(i)->Cleanup();
    }

    int numShape = this->GetShapeCount();
    for (int i = 0; i < numShape; ++i)
    {
        this->GetShape(i)->Cleanup();
    }

    int numVertex = this->GetVertexCount();
    for (int i = 0; i < numVertex; ++i)
    {
        this->GetVertex(i)->Cleanup();
    }
}

void ResModel::Reset()
{
    int numMaterial = this->GetMaterialCount();
    for (int i = 0; i < numMaterial; ++i)
    {
        this->GetMaterial(i)->Reset();
    }

    int numShape = this->GetShapeCount();
    for (int i = 0; i < numShape; ++i)
    {
        this->GetShape(i)->Reset();
    }

    int numVertex = this->GetVertexCount();
    for (int i = 0; i < numVertex; ++i)
    {
        this->GetVertex(i)->Reset();
    }

    ref().pUserPtr.set_ptr(NULL);
}

}}} // namespace nw::g3d::res

NW_G3D_PRAGMA_POP_WARNINGS
