﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d { namespace edit { namespace ut {

namespace detail {

template <typename T>
class FixedSizeArray
{
public:
    explicit FixedSizeArray()
        : m_pArray(NULL)
        , m_ArraySize(0)
    {}

    static size_t CalcBufferSize(int arrayCount);

    void SetArrayBuffer(void* arrayBuffer, int arrayCount)
    {
        NW_G3D_ASSERT_NOT_NULL(arrayBuffer);
        NW_G3D_ASSERT(arrayCount > 0);

        m_pArray = static_cast<T*>(arrayBuffer);
        m_ArraySize = arrayCount;
    }

    T* GetArrayBufferPtr()
    {
        return m_pArray;
    }
    const T* GetArrayBufferPtr() const
    {
        returnm_pArray;
    }

    void* GetBufferPtr()
    {
        return static_cast<void*>(m_pArray);
    }
    const void* GetBufferPtr() const
    {
        returnstatic_cast<void*>(m_pArray);
    }

    int Size() const
    {
        return m_ArraySize;
    }

    T* UnsafeAt(int index)
    {
        return &m_pArray[index];
    }

    const T* UnsafeAt(int index) const
    {
        return &m_pArray[index];
    }

    void Clear()
    {
        m_pArray = NULL;
        m_ArraySize = 0;
    }

private:
    T* m_pArray;
    int m_ArraySize;
};

template <typename T>
size_t FixedSizeArray<T>::CalcBufferSize(int arrayCount)
{
    NW_G3D_ASSERT(arrayCount > 0);
    return sizeof(T) * arrayCount;
}

} // namespace detail

}}}} // namespace nw::g3d::edit::ut

#endif // NW_G3D_CONFIG_USE_HOSTIO
