﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/g3d_IAllocator.h>

namespace nw { namespace g3d { namespace edit { namespace ut { namespace detail {

class EditWorkBuffer
{
public:
    explicit EditWorkBuffer(IAllocator* allocator, size_t alignment = DEFAULT_ALIGNMENT)
        : m_pAllocator(allocator)
        , m_Alignment(alignment)
        , m_pWorkBuffer(NULL)
        , m_WorkBufferSize(0)
    {
        NW_G3D_ASSERT_NOT_NULL(allocator);
    }

    ~EditWorkBuffer()
    {
        Clear();
    }

    void Clear()
    {
        NW_G3D_ASSERT_NOT_NULL(m_pAllocator);
        if (m_pWorkBuffer != NULL)
        {
            m_pAllocator->Free(m_pWorkBuffer);
            m_pWorkBuffer = NULL;
            m_WorkBufferSize = 0;
        }
    }

    void *GetWorkBufferPtr()
    {
        return m_pWorkBuffer;
    }

    const void *GetWorkBufferPtr() const
    {
        return m_pWorkBuffer;
    }

    template<typename T>
    T* GetWorkBufferPtr()
    {
        return reinterpret_cast<T*>(m_pWorkBuffer);
    }

    template<typename T>
    const T* GetWorkBufferPtr() const
    {
        returnreinterpret_cast<const T*>(m_pWorkBuffer);
    }

    size_t Size() const
    {
        return m_WorkBufferSize;
    }

    bool Resize(size_t size);

    bool Resize(size_t size, size_t alignment);

    void CopyAndFlush(const void* pBuffer, size_t size);

    void Flush();

private:
    bool ResizeImpl(size_t size);

private:
    IAllocator* m_pAllocator;
    size_t m_Alignment;
    void*   m_pWorkBuffer;
    size_t m_WorkBufferSize;
};

}}}}} // namespace nw::g3d::edit::ut::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
