﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#if NW_G3D_IS_HOST_CAFE

#include <cafe/hio.h>

#endif

namespace nw { namespace g3d { namespace edit {

class EditServer;

namespace detail {

class EditSocket
{
public:
    struct SetupArg
    {
#if NW_G3D_IS_HOST_WIN
        u16 portNumber;
#else
        const char* channelName; // 実機側は、チャンネル名を指定します。
#endif
        SetupArg()
#if NW_G3D_IS_HOST_WIN
            : portNumber(EDIT_DEFAULT_PORT_NUMBER) // 未使用ポート番号を利用します。
#else
            : channelName(EDIT_CHANNEL_NAME)
#endif
        {}
    };

public:
    explicit EditSocket();

    void Setup(const SetupArg& arg);

    bool Open();
    void Close();

    bool WriteASync(void* buf, u32 size);
    bool ReadASync(void* buf, u32 size);

    bool WriteSync(void* buf, u32 size);

    bool IsWriting() const;
    bool IsReading() const;

    void ResetWriteFlag();
    void ResetReadFlag();

    void Poll();

    bool IsConnected() const;

private:

#if NW_G3D_IS_HOST_WIN
    // ライブラリを組み合わせる場合に、Winsokライブラリの多重定義エラーを防ぐための対処です。
    struct Impl;
    Impl* m_Impl;
    u8 m_SocketMemberBuffer[32]; // バッファは多めにとっています。

    char*   m_pWriteBuffer;
    char*   m_pReadBuffer;

#else
    // HIOOpenに渡すホスト名は15文字まで
    static const int CHANNEL_NAME_LENGTH = 15;

    HIOHandle   m_Handle;
    HIOStatus   m_Status;
    HIOStatus   m_ReadStatus;
    HIOStatus   m_WriteStatus;

    bool m_IsConnected;
    bool m_IsWritingEnd;
    bool m_IsReadingEnd;
    volatile bool m_IsChangedToNoConnection;

    void*       m_pWriteBuffer;
    void*       m_pReadBuffer;
    char        m_ChannelName[CHANNEL_NAME_LENGTH + 1];

#endif

    volatile u32    m_WriteBufferSize;
    volatile u32    m_ReadBufferSize;

    volatile u32    m_WriteSize;
    volatile u32    m_WritingSize;
    volatile u32    m_TotalWritingSize;
    volatile bool   m_IsWriteEnd;

    volatile u32    m_ReadSize;
    volatile u32    m_ReadingSize;
    volatile u32    m_TotalReadingSize;
    volatile bool   m_IsReadEnd;

private:
    void ReadASyncInternal();
    void WriteASyncInternal();

#if NW_G3D_IS_HOST_CAFE
private:
    static void ConnectionCallback(HIOStatus status, void* context);
    static void WriteCallback(HIOStatus status, void* context);
    static void WritingCallback(HIOStatus status, void* context);

    static void ReadCallback(HIOStatus status, void* context);
    static void ReadingCallback(HIOStatus status, void* context);
#endif

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditSocket);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
