﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "ut/g3d_DynamicPtrArray.h"
#include "ut/g3d_DynamicLengthString.h"
#include "ut/g3d_EditWorkBuffer.h"

namespace nw { namespace g3d {

namespace res {

struct ResShaderProgramData;
class ResShaderProgram;
class ResShadingModel;
class ResShaderArchive;

} // namespace res

namespace edit {

class EditServer;
class IAllocator;

namespace detail {

class EditSocket;
class EditShadingModel;

/**
    @briefprivate 編集対象シェーダプログラムクラスです。
 */
class EditShaderProgram
{
    friend class EditShadingModel;
    friend void UpdateProgram(nw::g3d::ResShadingModel*, int);

public:
    void Cleanup();
    void Destroy();

    // 変更されたシェーダプログラムを3DEditor に送信します。
    bool SendModifiedShaderProgram(EditSocket* socket);
    bool MakeModifiedShaderProgramPacket();

    bool PushOptionInfo(const char* option, const char* choice);

    bool IsPacketEnabled() const
    {
        return m_PacketEnableFlag;
    }

    void UpdateShaderProgram(ResShaderArchive* resShaderArchive);

    void ClearOptionInfo();

    bool GetSendInfoCallbackFlag() const
    {
        return m_SendInfoCallbackFlag;
    }
    void SetSendInfoCallbackFlag(bool value)
    {
        m_SendInfoCallbackFlag = value;
    }

private:
    explicit EditShaderProgram(
        IAllocator* allocator,
        u32 shaderArchiveKey,
        int shadingModelIndex,
        int shaderProgramIndex,
        ResShaderProgram* resShaderProgram);

    size_t CalcWorkBufferSize();
    void MakeModifiedShaderProgramBuffer();

    class OptionInfo
    {
        friend class EditShaderProgram;
    public:
        explicit OptionInfo(IAllocator* allocator)
            : m_pAllocator(allocator)
            , m_Option(allocator)
            , m_Choice(allocator)
        {
            NW_G3D_ASSERT_NOT_NULL(allocator);
        }

        ~OptionInfo()
        {
            Clear();
            m_pAllocator = NULL;
        }

        bool Setup(const char* option, const char* choice);
        void Clear()
        {
            m_Option.Clear();
            m_Choice.Clear();
        }
    private:
        IAllocator* m_pAllocator;
        ut::detail::DynamicLengthString m_Option;
        ut::detail::DynamicLengthString m_Choice;
        u32 m_OptionOffset;
        u32 m_ChoiceOffset;
        u32 m_OptionBinarySize;
        u32 m_ChoiceBinarySize;
    };

private:
    enum
    {
        NUM_STAGE = 4
    };

    IAllocator*             m_pAllocator;
    ResShaderProgram*       m_pTargetResShaderProgram;
    ResShaderProgramData*   m_pEditResShaderProgramData;
    ResShaderArchive*       m_pUpdateResShaderArchive;
    u32                     m_OriginalHandle;

    u16     m_OriginalFlag;
    u8      m_OriginalNumSampler;
    u8      m_OriginalNumUniformBlock;
    u32     m_OriginalAttribuActiveFlag;
    u16     m_OriginalNumALUInst[NUM_STAGE];
    u16     m_OriginalNumTfetchInst[NUM_STAGE];
    u16     m_OriginalNumVfetchInst[NUM_STAGE];
    u16     m_OriginalNumCflowInst[NUM_STAGE];

    void*   m_OriginalOffsetSamplerTable;
    void*   m_OriginalOffsetUniformBlockTable;
    void*   m_OriginalOffsetVertexShader;
    void*   m_OriginalOffsetGeometryShader;
    void*   m_OriginalOffsetGeometryCopyShader;
    void*   m_OriginalOffsetFragmentShader;
    void*   m_OriginalOffsetComputeShader;

    ut::detail::EditWorkBuffer m_WorkBuffer;
    ut::detail::DynamicPtrArray<OptionInfo> m_OptionInfos;
    size_t m_ModifiedShaderProgramBufferSize;
    u32 m_ShaderArchiveKey;
    int m_ShadingModelIndex;
    int m_ShaderProgramIndex;
    bool m_PacketEnableFlag;
    bool m_SendInfoCallbackFlag;

    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditShaderProgram);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO
