﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditRenderInfoObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/g3d_MaterialObj.h>
#include <nw/g3d/res/g3d_ResMaterial.h>
#include <nw/g3d/edit/g3d_IAllocator.h>

namespace nw { namespace g3d { namespace edit { namespace detail {

using namespace ut::detail;

void
EditRenderInfoObj::Cleanup()
{
    m_pUpdatedMaterial->ref().ofsRenderInfoDic.set_ptr(m_pUpdatedRenderInfoDic);
    m_pOriginalMaterial->ref().ofsRenderInfoDic.set_ptr(m_pOriginalRenderInfoDic);
    m_pOriginalMaterial->ref().numRenderInfo = m_OriginalNumRenderInfo;
}

void
EditRenderInfoObj::Destroy()
{
    m_WorkBuffer.Clear();
}

void
EditRenderInfoObj::UpdateMaterial(nw::g3d::res::ResMaterial* resMaterial)
{
    NW_G3D_ASSERT_NOT_NULL_DETAIL(resMaterial, "%s\n", NW_G3D_RES_GET_NAME(m_pOriginalMaterial, GetName()));
    Cleanup();
    m_pUpdatedRenderInfoDic = resMaterial->ref().ofsRenderInfoDic.to_ptr();
    m_pUpdatedMaterial = resMaterial;
}

void
EditRenderInfoObj::Update(const void* pRenderInfoDic, size_t dataSize)
{
    NW_G3D_ASSERT_NOT_NULL_DETAIL(pRenderInfoDic, "%s\n", NW_G3D_RES_GET_NAME(m_pOriginalMaterial, GetName()));
    NW_G3D_ASSERTMSG(dataSize > 0, "%s\n", NW_G3D_RES_GET_NAME(m_pOriginalMaterial, GetName()));

    Cleanup();// 一旦元に戻す、必要ない場合はこの処理を削除

    bool result = m_WorkBuffer.Resize(dataSize);
    NW_G3D_ASSERTMSG(result, "%s\n", NW_G3D_RES_GET_NAME(m_pOriginalMaterial, GetName()));

    m_WorkBuffer.CopyAndFlush(pRenderInfoDic, dataSize);
    ResDicPatriciaData* renderInfoDic = m_WorkBuffer.GetWorkBufferPtr<ResDicPatriciaData>();

    m_UpdateNumRenderInfo = static_cast<u16>(renderInfoDic->numData);
    m_pUpdatedMaterial->ref().ofsRenderInfoDic.set_ptr(m_WorkBuffer.GetWorkBufferPtr());
    m_pUpdatedMaterial->ref().numRenderInfo = m_UpdateNumRenderInfo;
}

EditRenderInfoObj::EditRenderInfoObj(
    IAllocator* allocator,
    nw::g3d::MaterialObj* ownerMaterialObj)
    : m_pAllocator(allocator)
    , m_pOwnerMaterial(ownerMaterialObj)
    , m_pOriginalRenderInfoDic(NULL)
    , m_WorkBuffer(allocator, MaterialObj::BUFFER_ALIGNMENT)
{
    NW_G3D_ASSERT_NOT_NULL(allocator);
    NW_G3D_ASSERT_NOT_NULL(ownerMaterialObj);
    nw::g3d::res::ResMaterial* resMaterial = ownerMaterialObj->GetResource();
    NW_G3D_ASSERT_NOT_NULL(resMaterial);

    m_pOriginalMaterial = resMaterial;
    m_pOriginalRenderInfoDic = resMaterial->ref().ofsRenderInfoDic.to_ptr();
    m_OriginalNumRenderInfo = resMaterial->ref().numRenderInfo;

    m_pUpdatedMaterial = m_pOriginalMaterial;
    m_pUpdatedRenderInfoDic = m_pOriginalRenderInfoDic;
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
