﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d {
namespace edit {
namespace detail {

/**
    @briefprivate 点滅可能な抽象オブジェクトクラスです。
*/
class BlinkingObj
{
public:
    BlinkingObj() throw()
        : m_RestFrameCountForBlinking(0)
        , m_IsVisible(false)
    {
    }
    virtual ~BlinkingObj() throw(){}

    // @brief 点滅を開始します。
    void StartBlinking() throw();

    // @brief 点滅状態を更新します。
    bool UpdateBlinking() throw();

    // @biref 点滅を強制的に終了します。
    void BreakBlinking() throw();

    // @biref 点滅中であればtrue、そうでなければfalseを返します。
    bool IsBlinking() const throw()
    {
        return m_RestFrameCountForBlinking > 0;
    }

private:
    // @brief 表示状態にする処理を記述します。
    virtual void Show() = 0;

    // @brief 非表示状態にする処理を記述します。
    virtual void Hide() = 0;

    // @brief 通常は表示状態であるかどうかを記述します。
    virtual bool IsVisibleByDefault() const = 0;

private:
    int m_RestFrameCountForBlinking;
    bool m_IsVisible;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(BlinkingObj);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO

