﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditAnimObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/g3d_AnimObj.h>
#include <nw/g3d/res/g3d_ResFile.h>
#include <nw/g3d/edit/g3d_IAllocator.h>
#include "g3d_EditAnimCurve.h"

namespace nw { namespace g3d { namespace edit { namespace detail {


//--------------------------------------------------------------------------------------------------

/*virtual*/void
EditAnimObj::FreeAnimObjBuffers()
{
    NW_G3D_EDIT_ASSERT_NOT_NULL_DETAIL(m_pAllocator, "%s\n", NW_G3D_RES_GET_NAME(m_pResFile, GetName()));
    for (int i = 0, end = m_BoundModelInfos.Size(); i < end; ++i)
    {
        ModelAnimObj* pAnimObj = m_BoundModelInfos[i]->pAnimObj;
        void* buffer = pAnimObj->GetBufferPtr();
        if (buffer)
        {
            m_pAllocator->Free(buffer);
        }
    }

    m_SetupFlag = false;
}

bool EditAnimObj::ReloadResource(nw::g3d::res::ResFile* pResFile)
{
    const char* pResName = GetResName(pResFile, ConvertToFileDataKind(GetAnimKind()));
    NW_G3D_UNUSED(pResName);
    NW_G3D_ASSERT_NOT_NULL_DETAIL(pResFile, "%s\n", pResName);
    NW_G3D_ASSERTMSG(IsValidResFile(pResFile), "%s\n", pResName);

    // 新しくストアする情報を退避
    bool isSetupAlreadyDone = m_SetupFlag;
    ut::detail::DynamicArray<BoundModelInfo> currentBoundModelObjs(m_pAllocator, DEFAULT_ALIGNMENT);
    GetBoundModelObjs(&currentBoundModelObjs);

    // 内部状態をクリア
    UnbindAllModelObjs();
    DestroyDataForEditingAnimCurve();

    // 再構築
    {
        SetResource(pResFile);

        {
            bool success = CreateDataForEditingAnimCurve();
            if (!success)
            {
                return false;
            }
        }

        if (isSetupAlreadyDone)
        {
            for (int i = 0, end = currentBoundModelObjs.Size(); i < end; ++i)
            {
                BoundModelInfo* pOldInfo = &currentBoundModelObjs[i];
                bool success = BindModelObj(pOldInfo->pBoundModelObj);
                if (!success)
                {
                    UnbindAllModelObjs();
                    DestroyDataForEditingAnimCurve();
                    return false;
                }

                BoundModelInfo* pAddedInfo = m_BoundModelInfos[m_BoundModelInfos.Size() - 1];
                pAddedInfo->isPaused = pOldInfo->isPaused;
                pAddedInfo->pauseFrame = pOldInfo->pauseFrame;
            }
        }
        else
        {
            AddBoundModelObjs(currentBoundModelObjs);
        }
    }

    return true;
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
