﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditAnimCurve.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/g3d_IAllocator.h>

namespace {
    int GetKeyValueCount(const nw::g3d::res::ResAnimCurveData* targetAnimCurveData)
    {
        bit32 curveType = targetAnimCurveData->flag & nw::g3d::res::ResAnimCurve::CURVE_MASK;
        switch (curveType)
        {
        case nw::g3d::res::ResAnimCurve::CURVE_CUBIC: return targetAnimCurveData->numKey * 4;
        case nw::g3d::res::ResAnimCurve::CURVE_LINEAR: return targetAnimCurveData->numKey * 2;
        case nw::g3d::res::ResAnimCurve::CURVE_STEP_INT:
        case nw::g3d::res::ResAnimCurve::CURVE_STEP_BOOL:
        default:
            return targetAnimCurveData->numKey;
        }
    }

    size_t GetFrameArraySize(const nw::g3d::res::ResAnimCurveData* pResAnimCurveData)
    {
        bit32 frameType = pResAnimCurveData->flag & nw::g3d::res::ResAnimCurve::FRAME_MASK;
        switch (frameType)
        {
        case nw::g3d::res::ResAnimCurve::FRAME32: return sizeof(float) * pResAnimCurveData->numKey;
        case nw::g3d::res::ResAnimCurve::FRAME16: return sizeof(u16) * pResAnimCurveData->numKey;
        case nw::g3d::res::ResAnimCurve::FRAME8: return sizeof(u8) * pResAnimCurveData->numKey;
        default:
            NW_G3D_EDIT_UNEXPECTED_DEFAULT;
        }

        return 0;
    }

    size_t GetKeyArraySize(const nw::g3d::res::ResAnimCurveData* pResAnimCurveData)
    {
        bit32 keyType = pResAnimCurveData->flag & nw::g3d::res::ResAnimCurve::KEY_MASK;
        int keyValueCount = GetKeyValueCount(pResAnimCurveData);
        switch (keyType)
        {
        case nw::g3d::res::ResAnimCurve::KEY32: return sizeof(float) * keyValueCount;
        case nw::g3d::res::ResAnimCurve::KEY16: return sizeof(u16) * keyValueCount;
        case nw::g3d::res::ResAnimCurve::KEY8: return sizeof(u8) * keyValueCount;
        default:
            NW_G3D_EDIT_UNEXPECTED_DEFAULT;
        }

        return 0;
    }
}

namespace nw { namespace g3d { namespace edit { namespace detail {

void EditAnimCurve::Setup()
{
    NW_G3D_ASSERT_NOT_NULL(m_pAnimCurve);
    m_OrgAnimCurveData = m_pAnimCurve->ref();
    m_OrgAnimCurve = nw::g3d::res::ResAnimCurve::ResCast(&m_OrgAnimCurveData);
}

void EditAnimCurve::Cleanup()
{
    NW_G3D_ASSERT_NOT_NULL(m_pAnimCurve);
    nw::g3d::res::ResAnimCurveData* resAnimCurveData = m_pAnimCurve->ptr();

    resAnimCurveData->flag = m_OrgAnimCurveData.flag;
    resAnimCurveData->numKey = m_OrgAnimCurveData.numKey;
    resAnimCurveData->targetOffset = m_OrgAnimCurveData.targetOffset;
    resAnimCurveData->startFrame = m_OrgAnimCurveData.startFrame;
    resAnimCurveData->endFrame = m_OrgAnimCurveData.endFrame;
    resAnimCurveData->iScale = m_OrgAnimCurveData.iScale;
    resAnimCurveData->iOffset = m_OrgAnimCurveData.iOffset;
    resAnimCurveData->fDelta = m_OrgAnimCurveData.fDelta;
    resAnimCurveData->ofsFrameArray = m_OrgAnimCurveData.ofsFrameArray.operator s32();
    resAnimCurveData->ofsKeyArray = m_OrgAnimCurveData.ofsKeyArray.operator s32();
    m_FrameArrayBuffer.Clear();
    m_KeyArrayBuffer.Clear();
}

void EditAnimCurve::Edit(const nw::g3d::res::ResAnimCurveData* pResAnimCurveData, size_t curveDataSize)
{
    NW_G3D_ASSERT_NOT_NULL(pResAnimCurveData);
    NW_G3D_ASSERT(curveDataSize > 0);
    NW_G3D_ASSERT_NOT_NULL(m_pAnimCurve);

    nw::g3d::res::ResAnimCurveData* targetAnimCurveData = m_pAnimCurve->ptr();

    targetAnimCurveData->flag = pResAnimCurveData->flag;
    targetAnimCurveData->numKey = pResAnimCurveData->numKey;
    targetAnimCurveData->targetOffset = pResAnimCurveData->targetOffset;
    targetAnimCurveData->startFrame = pResAnimCurveData->startFrame;
    targetAnimCurveData->endFrame = pResAnimCurveData->endFrame;
    targetAnimCurveData->iScale = pResAnimCurveData->iScale;
    targetAnimCurveData->iOffset = pResAnimCurveData->iOffset;
    targetAnimCurveData->fDelta = pResAnimCurveData->fDelta;

    size_t frameArraySize = GetFrameArraySize(pResAnimCurveData);
    m_FrameArrayBuffer.Resize(frameArraySize);
    memcpy(m_FrameArrayBuffer.GetWorkBufferPtr(), pResAnimCurveData->ofsFrameArray.to_ptr(), frameArraySize);
    targetAnimCurveData->ofsFrameArray.set_ptr(m_FrameArrayBuffer.GetWorkBufferPtr());

    size_t keyArraySize = GetKeyArraySize(pResAnimCurveData);
    m_KeyArrayBuffer.Resize(keyArraySize);
    memcpy(m_KeyArrayBuffer.GetWorkBufferPtr(), pResAnimCurveData->ofsKeyArray.to_ptr(), keyArraySize);
    targetAnimCurveData->ofsKeyArray.set_ptr(m_KeyArrayBuffer.GetWorkBufferPtr());
}


}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
