﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d { namespace edit { namespace detail {

class EditSocket;

class EditAnimControl
{
public:
    explicit EditAnimControl();

    ~EditAnimControl()
    {
    }

    bool SendAnimControl(EditSocket* socket);

    void SetAnimFlag(bool enable, float frame)
    {
        m_SendAnimFrameCtrlPacket.header.command =
            (enable ? SYSTEM_PLAY_FRAME_CTRL_COMMAND_FLAG : SYSTEM_STOP_FRAME_CTRL_COMMAND_FLAG);
        m_SendAnimFrameCtrlPacket.block.frame = frame;
    }

    void SetFrame(float value)
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_FRAME_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.frame = value;
    }

    void SetFrameStep(float value)
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_FRAME_STEP_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.frameStep = value;
    }

    void SetNextModelAnim(const ModelObj* modelObj)
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_MODEL_NEXT_ANIM_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.modelKey = reinterpret_cast<u32>(modelObj);
    }

    void SetPrevModelAnim(const ModelObj* modelObj)
    {
        m_SendAnimFrameCtrlPacket.header.command = SYSTEM_SEND_MODEL_PREV_ANIM_COMMAND_FLAG;
        m_SendAnimFrameCtrlPacket.block.modelKey = reinterpret_cast<u32>(modelObj);
    }
private:
    FrameCtrlPacket m_SendAnimFrameCtrlPacket;
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
