﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.ndd
{
    [CppRefPath(@"<nn/ndd/ndd_Types.h>")]
    [ExternalStruct(8, 1)]
    public struct DataId { }

    [CppRefPath(@"<nn/ndd/ndd_Types.h>")]
    [ExternalStruct(1216, 2)]
    [LargeData(true)]
    public struct SendDataDescription { }

    [CppRefPath(@"<nn/ndd/ndd_Types.h>")]
    [ExternalStruct(1232, 8)]
    [LargeData(true)]
    public struct ReceiveDataDescription { }

    public interface IService : IServiceObject
    {
        [MethodId(1)]
        Result EnableAutoCommunication();

        [MethodId(2)]
        Result DisableAutoCommunication();

        [MethodId(3)]
        Result IsAutoCommunicationEnabled(Out<bool> pIsEnabled);

        [MethodId(4)]
        Result IsNetworkActive(Out<bool> pIsActive);

        [MethodId(100)]
        Result AcquireSendDataUpdateEvent(Out<NativeHandle> handle);

        [MethodId(101)]
        Result AddSendData(SendDataDescription data);

        [MethodId(102)]
        Result ClearSendData();

        [MethodId(103)]
        Result GetSendData(Out<SendDataDescription> pBuffer, Out<int> pCount, int offset, int count);

        [MethodId(201)]
        Result AcquireReceiveDataEvent(Out<NativeHandle> handle);

        [MethodId(202)]
        Result GetCurrentReceiveDataCounter(Out<uint32_t> pCounter);

        [MethodId(203)]
        Result GetOldestReceiveDataCounter(Out<uint32_t> pCounter);

        [MethodId(204)]
        Result GetNextReceiveDataCounter(Out<uint32_t> pCounter);

        [MethodId(205)]
        Result GetAvailableReceiveDataCount(Out<int> pCounter, uint32_t counter);

        [MethodId(206)]
        Result GetRecentReceiveDataCounter(Out<uint32_t> pCounter, uint32_t counter, int count);

        [MethodId(207)]
        Result GetReceiveData([AutoSelectBuffer] OutArray<ReceiveDataDescription> pBuffer, Out<int> pCount, Out<uint32_t> pNextCounter, uint32_t counter);

        [MethodId(208)]
        Result AddReceiveData(ReceiveDataDescription data);

        [MethodId(209)]
        Result ClearReceiveData();

        [MethodId(210)]
        Result ClearDataIdFilter();

        [MethodId(300)]
        Result AcquireDeviceScanEvent(Out<NativeHandle> handle);

        [MethodId(301)]
        Result StartDeviceScan();

        [MethodId(302)]
        Result CancelDeviceScan();

        [MethodId(303)]
        Result GetDeviceScanResult([AutoSelectBuffer] OutArray<ReceiveDataDescription> pBuffer, Out<int> pCount);


 //       void LendDeviceScanMemory(nn::os::NativeHandle handle);
 //       void PullbackDeviceScanMemory(nn::os::NativeHandle handle);
    }

    public interface IServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateNddService(Out<IService> pOutService);
    }
}
