﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>

#include <nn/ndd/detail/ndd_InternalTypes.h>
#include <nn/ndd/detail/ndd_Utility.h>
#include <nn/ndd/detail/ndd_Message.h>
#include <nn/ndd/ndd_PrivateResult.h>

namespace nn { namespace ndd {

void Message::Set(int id)
{
    m_Id = id;
}

void Message::Set(int id, const void* pData, size_t size)
{
    NN_ABORT_UNLESS(size <= DataSizeMax);
    m_Id = id;
    memcpy(&m_Data[0], pData, size);
}

int Message::GetId() const
{
    return m_Id;
}

const uint8_t* Message::GetDataPtr() const
{
    return &m_Data[0];
}

}}
