﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nd/nd_ApiForDebug.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>
#include <nn/nd/nd_Result.h>
#include <nn/nd/detail/nd_InitializationManager.h>
#include <nn/nd/detail/nd_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include "detail/nd_HipcProxyClientResource.h"

namespace nn { namespace nd {

extern detail::InitializationManager g_Init;
extern detail::ObjectHolder g_ObjectHolder;

void AddReceivedNeighborInfoForSystemForDebug(NeighborInfoForSystem info[], int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(info);
    NN_SDK_REQUIRES_GREATER(count, 0);

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ObjectHolder.GetForSystem().AddReceivedNeighborInfoForSystemForDebug(sf::InArray<NeighborInfoForSystem>(info, count)));
}

void GetSendDataForDebug(ndd::SendDataDescription *pOut, const account::Uid& uid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES(uid);

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ObjectHolder.GetForSystem().GetSendDataForDebug(pOut, uid));
}

void ClearReceiveCounterForDebug(const account::Uid& uid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(uid);

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ObjectHolder.GetForSystem().ClearReceiveCounterForDebug(uid));
}

}} // ~namespace nn::nd
