﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "nd_HipcProxyClientResource.h"

#include <nn/nn_Common.h>
#include <nn/nd/service/nd_ServiceResource.h>

namespace nn { namespace nd { namespace detail {

namespace {

nn::MemoryResource& GetMemoryResource() NN_NOEXCEPT
{
    static Bit8 s_HeapMemory[8 * 1024];
    NN_FUNCTION_LOCAL_STATIC(lmem::HeapHandle, s_HeapHandle, = lmem::CreateExpHeap(s_HeapMemory, sizeof(s_HeapMemory), lmem::CreationOption_ThreadSafe));
    NN_FUNCTION_LOCAL_STATIC(sf::ExpHeapMemoryResource, s_MemoryResource, { s_HeapHandle });
    return s_MemoryResource;
}

} // ~namespace nn::nd::detail::<anonymous>

service::ServiceResource& GetServiceResourceRef() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(service::ServiceResource, g_Instance, { GetMemoryResource() });
    return g_Instance;
}

}}} // ~namespace nn::nd::detail
