﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nd/detail/nd_Log.h>
#include <nn/nd/detail/nd_FirmwareDebugSettings.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace nd { namespace detail {

namespace {

const auto DefaultSendDataIdRefreshInterval = nn::TimeSpan::FromHours(8);

template <typename T>
T GetSettingsValue(const char* key, T defaultValue) NN_NOEXCEPT
{
    T value;
    auto size = settings::fwdbg::GetSettingsItemValue(&value, sizeof(value), "nd", key);
    if( !(size == sizeof(value)) )
    {
        NN_DETAIL_ND_ERROR("[nd] Failed to fwdbg::GetSettingsValue(%s): size = %d(expected:%d)\n", key, static_cast<int>(size), static_cast<int>(sizeof(value)));
        return defaultValue;
    }
    return value;
}

} // ~ nn::nd::detail::<anonymous>

// 初期値は Programs\Iris\Sources\Libraries\nd\fwdbg\nd.fwdbg.production.yml に合わせる

bool FirmwareDebugSettings::s_IsDevelopmentFunctionEnabled = false;
TimeSpan FirmwareDebugSettings::s_SendDataIdRefreshInterval;

void FirmwareDebugSettings::Initialize() NN_NOEXCEPT
{
    s_IsDevelopmentFunctionEnabled = GetSettingsValue<bool>("development_function_enabled", false);
    const int SendDataIdRefreshIntervalSecondsMin = 10;
    auto sendDataIdRefreshIntervalSeconds = GetSettingsValue<int32_t>("send_data_id_refresh_interval_seconds", static_cast<int32_t>(DefaultSendDataIdRefreshInterval.GetSeconds()));
    if( sendDataIdRefreshIntervalSeconds < SendDataIdRefreshIntervalSecondsMin )
    {
        NN_DETAIL_ND_WARN("[nd] send_data_id_refresh_interval_seconds(%d) is too small. Its minimum value is %d.\n",
            sendDataIdRefreshIntervalSeconds, SendDataIdRefreshIntervalSecondsMin);
        sendDataIdRefreshIntervalSeconds = SendDataIdRefreshIntervalSecondsMin;
    }
    s_SendDataIdRefreshInterval = TimeSpan::FromSeconds(sendDataIdRefreshIntervalSeconds);
}

bool FirmwareDebugSettings::IsDevelopmentFunctionEnabled() NN_NOEXCEPT
{
    return s_IsDevelopmentFunctionEnabled;
}

TimeSpan FirmwareDebugSettings::GetSendDataIdRefreshInterval() NN_NOEXCEPT
{
    return s_SendDataIdRefreshInterval;
}

}}} // ~namespace nn::nd::detail
