﻿using System;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.util
{
    [ExternalStruct(16, 1)]
    [CppRefPath("<nn/util/util_UuidTypes.h>")]
    public struct Uuid
    {
    }
}

namespace nn.account
{
    [ExternalStruct(16, 8)]
    [Pre(@"static_cast<bool>(_)")]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct Uid
    {
    }

    [ExternalStruct(33, 1)]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct Nickname
    {
    }

    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct NetworkServiceAccountId
    {
    }

    [ExternalStruct(8, 8)]
    [Pre(@"static_cast<bool>(_)")]
    [CppRefPath("<nn/account/account_NintendoAccountTypes.h>")]
    public struct NintendoAccountId
    {
    }

    [ExternalStruct(16, 1)]
    [CppRefPath("<nn/account/account_TypesForSystemServices.h>")]
    public struct SessionId
    {
    }
}

namespace nn.ncm
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/ncm/ncm_ContentMetaId.h>")]
    public struct ApplicationId
    {
    }

}

namespace nn.migration
{
    [Serializable]
    [AttributeUsage(AttributeTargets.Parameter, AllowMultiple = true)]
    public class NotNullAttribute : PreAttribute
    {
        public NotNullAttribute()
            : base("_.GetPointerUnsafe() != nullptr && _.GetSize() > 0")
        {
        }
    }

    [Serializable]
    [AttributeUsage(AttributeTargets.Parameter, AllowMultiple = true)]
    public class NotEmptyAttribute : PreAttribute
    {
        public NotEmptyAttribute()
            : base("_.GetData() != nullptr && _.GetLength() > 0")
        {
        }
    }

    [LargeData]
    [ExternalStruct(256, 1)]
    [CppRefPath("<nn/migration/migration_UserMigrationTypes.h>")]
    public struct UserMigrationServerProfile
    {
    }

    [LargeData]
    [ExternalStruct(256, 1)]
    [CppRefPath("<nn/migration/migration_UserMigrationTypes.h>")]
    public struct UserMigrationClientProfile
    {
    }

    [LargeData]
    [ExternalStruct(272, 1)]
    [CppRefPath("<nn/migration/migration_UserMigrationTypes.h>")]
    public struct UserMigrationServerInfo
    {
    }

    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/migration/migration_UserMigrationTypes.h>")]
    public struct TransferInfo
    {
    }
}

namespace nn.migration.user
{
    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/migration/user/migration_UserMigrationInternalTypes.h>")]
    public struct LastMigrationInfo
    {
    }
}

namespace nn.migration.detail
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn/migration/detail";
        public const string Path = Prefix + Root + @"/migration_Interface.sfdl.h" + Postfix;
    }

    [CppRefPath(PathInfo.Path)]
    public interface IAsyncContext
        : IServiceObject
    {
        [MethodId(0)]
        Result GetSystemEvent(Out<NativeHandle> pOutHandle);

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result HasDone(Out<bool> pOut);

        [MethodId(3)]
        Result GetResult();
    }
}

namespace nn.migration.user
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn/migration/user";
        public const string Path = Prefix + Root + @"/migration_Interface.sfdl.h" + Postfix;
    }

    [CppRefPath(PathInfo.Path)]
    public interface IService
        : IServiceObject
    {
        [MethodId(10)]
        Result TryGetLastMigrationInfo(Out<bool> pOutResult, Out<LastMigrationInfo> pOutData);


        [MethodId(100)]
        Result CreateServer(Out<IServer> pOut, account.Uid uid, UserMigrationServerProfile profile, NativeHandle workMemory, UInt32 workMemorySize);

        [MethodId(101)]
        Result ResumeServer(Out<IServer> pOut, NativeHandle workMemory, UInt32 workMemorySize);


        [MethodId(200)]
        Result CreateClient(Out<IClient> pOut, UserMigrationClientProfile profile, NativeHandle workMemory, UInt32 workMemorySize);

        [MethodId(201)]
        Result ResumeClient(Out<IClient> pOut, NativeHandle workMemory, UInt32 workMemorySize);
    }

    [CppRefPath(PathInfo.Path)]
    public interface IServer
        : IServiceObject
    {
        [MethodId(0)]
        Result GetUid(Out<account.Uid> pOut);

        [MethodId(1)]
        Result GetServerProfile(Out<UserMigrationServerProfile> pOut);


        [MethodId(100)]
        Result PrepareAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(101)]
        Result GetConnectionRequirement(Out<bool> pOut);


        [MethodId(200)]
        Result WaitConnectionAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(201)]
        Result GetClientProfile(Out<UserMigrationClientProfile> pOut);

        [MethodId(202)]
        Result AcceptConnectionAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(203)]
        Result DeclineConnectionAsync(Out<detail.IAsyncContext> pOut);


        [MethodId(300)]
        Result ProcessTransferAsync(Out<detail.IAsyncContext> pOut);


        [MethodId(400)]
        Result CompleteAsync(Out<detail.IAsyncContext> pOut);


        [MethodId(500)]
        Result Abort();
    }

    [CppRefPath(PathInfo.Path)]
    public interface IClient
        : IServiceObject
    {
        [MethodId(0)]
        Result GetClientProfile(Out<UserMigrationClientProfile> pOut);


        [MethodId(10)]
        Result CreateLoginSession(Out<account.SessionId> pOut);

        [MethodId(11)]
        Result GetNetworkServiceAccountId(Out<account.NetworkServiceAccountId> pOut);

        [MethodId(12)]
        Result GetUserNickname(Out<account.Nickname> pOut);

        [MethodId(13)]
        Result GetUserProfileImage(Out<UInt32> pOutActualSize, [NotNull][BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer pOutImage);


        [MethodId(100)]
        Result PrepareAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(101)]
        Result GetConnectionRequirement(Out<bool> pOut);


        [MethodId(200)]
        Result ScanServersAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(201)]
        Result ListServers(Out<UInt32> pOutCount, [NotEmpty][BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<UserMigrationServerInfo> servers);

        [MethodId(210)]
        Result ConnectByServerIdAsync(Out<detail.IAsyncContext> pOut, util.Uuid serverId);


        [MethodId(300)]
        Result GetStorageShortfall(Out<Int64> pOut);

        [MethodId(301)]
        Result GetTotalTransferInfo(Out<TransferInfo> pOut);

        [MethodId(302)]
        Result GetImmigrantUid(Out<account.Uid> pOut);

        [MethodId(310)]
        Result GetCurrentTransferInfo(Out<TransferInfo> pOut);

        [MethodId(311)]
        Result GetCurrentRelatedApplications(Out<UInt32> pOut, [NotEmpty][BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.ApplicationId> apps);

        [MethodId(320)]
        Result TransferNextAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(350)]
        Result SuspendAsync(Out<detail.IAsyncContext> pOut);


        [MethodId(400)]
        Result CompleteAsync(Out<detail.IAsyncContext> pOut);

        [MethodId(500)]
        Result Abort();

        [MethodId(999)]
        Result DebugSynchronizeStateInFinalizationAsync(Out<detail.IAsyncContext> pOut);
    }
}
