﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/migration/migration_AsyncContext.h>

#include <nn/migration/detail/migration_Interface.sfdl.h>
#include <nn/migration/detail/migration_Diagnosis.h>
#include <nn/migration/detail/migration_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace migration {

void swap(AsyncContext& o0, AsyncContext& o1) NN_NOEXCEPT
{
    std::swap(o0.m_Ptr, o1.m_Ptr);
}

AsyncContext::AsyncContext() NN_NOEXCEPT
    : m_Ptr(nullptr)
{
}
AsyncContext::AsyncContext(detail::IAsyncContext* ptr) NN_NOEXCEPT
    : m_Ptr(ptr)
{
}
AsyncContext::AsyncContext(AsyncContext&& rhs) NN_NOEXCEPT
    : m_Ptr(rhs.m_Ptr)
{
    rhs.m_Ptr = nullptr;
}
AsyncContext::~AsyncContext() NN_NOEXCEPT
{
    if (m_Ptr)
    {
        NN_ABORT_UNLESS(HasDone());
        sf::ReleaseSharedObject(m_Ptr);
    }
}
AsyncContext& AsyncContext::operator=(AsyncContext&& rhs) NN_NOEXCEPT
{
    AsyncContext tmp(std::move(rhs));
    swap(*this, tmp);
    return *this;
}

void AsyncContext::GetSystemEvent(os::SystemEvent* pOut) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);

    sf::NativeHandle handle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->GetSystemEvent(&handle));
    pOut->AttachReadableHandle(handle.GetOsHandle(), handle.IsManaged(), os::EventClearMode_ManualClear);
    handle.Detach();
}
void AsyncContext::Cancel() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->Cancel());
}
bool AsyncContext::HasDone() const NN_NOEXCEPT
{
    bool done;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->HasDone(&done));
    return done;
}
Result AsyncContext::GetResult() const NN_NOEXCEPT
{
    NN_ABORT_UNLESS(HasDone());
    return m_Ptr->GetResult();
}

}} // ~namespace nn::migration
