﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/migration/idc/migration_Result.h>
#include <nn/migration/detail/migration_Log.h>
#include <nn/migration/idc/detail/migration_HandleSocketError.h>
#include <nn/migration/idc/detail/migration_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/socket/socket_Errno.h>

namespace nn { namespace migration { namespace idc { namespace detail {

Result HandleSocketError(nn::socket::Errno socketError) NN_NOEXCEPT
{
    NN_DETAIL_MIGRATION_TRACE("HandleSocketError : %d\n", socketError);

    if( socketError == nn::socket::Errno::ESuccess )
    {
        NN_RESULT_SUCCESS;
    }

#if defined (NN_BUILD_CONFIG_OS_WIN32)
    switch( socketError )
    {
    case socket::Errno::EIntr:          // 受信待ち中に Close。
        NN_ABORT("Intr\n");
    case socket::Errno::EBadf:          // 自身が切断済みの状態での処理要求。
        NN_ABORT("Badf\n");
    case socket::Errno::EConnAborted:   // 相手が切断済みの状態での受信要求/送信要求。
        NN_RESULT_THROW(idc::ResultPeerClosed());
    case socket::Errno::EConnReset:     // 送信後、相手が切断済みの状態で再度送信。
        NN_RESULT_THROW(idc::ResultPeerClosed());
    default:
        // TODO : デバッグできるように細分化。
        NN_RESULT_THROW(idc::detail::ResultUnknownConnectionError());
    }
#else
    switch( socketError )
    {
    case socket::Errno::EBadf:        // 自身が切断済みの状態での処理要求。
        NN_ABORT("Badf");
    case socket::Errno::EPipe:        // 相手が切断済みの状態での送信要求。
    case socket::Errno::EConnReset:   // 相手が切断済みの状態での一回目の受信要求（二回目以降は受信バイト数が 0 になる）。ConnReset 自体は相手が切断済みの状態でのシャットダウンも発生する。
        NN_RESULT_THROW(idc::ResultPeerClosed());
    default:
        // TODO : デバッグできるように細分化。
        NN_RESULT_THROW(idc::detail::ResultUnknownConnectionError());
    }
#endif
}

}}}}
