﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/migration/migration_Result.h>
#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_Utility.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace migration { namespace detail {

template <typename Operator>
Result AggregateSaveData(Operator& op, const detail::Cancellable* pCancellable) NN_NOEXCEPT
{
    int spaceCount;
    const auto* spaceIds = op.GetTargetSpaceIds(&spaceCount);

    for (auto i = 0; i < spaceCount; ++ i)
    {
        auto spaceId = spaceIds[i];

        std::unique_ptr<fs::SaveDataIterator> iter;
        NN_RESULT_DO(fs::OpenSaveDataIterator(&iter, spaceId));

        while (NN_STATIC_CONDITION(true))
        {
            if (detail::IsCanceled(pCancellable))
            {
                NN_RESULT_THROW(ResultCanceled());
            }

            int64_t count;
            fs::SaveDataInfo info;
            NN_RESULT_DO(iter->ReadSaveDataInfo(&count, &info, 1));
            if (count == 0)
            {
                break;
            }

            if (op.Filter(info))
            {
                NN_RESULT_DO(op.Process(info));
            }
        }
    }
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::migration::detail
