﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/migration/detail/migration_IdcClient.h>

#include <nn/migration/detail/migration_NetworkConnection.h>
#include <nn/migration/detail/migration_Authenticator.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/result/result_HandlingUtility.h>

#include "migration_FsUtil.h"

namespace nn { namespace migration { namespace detail {

Result IdcClientBase::InitializeFileSystemParameters(const OnetimeToken& ott, AuthenticationBuffer& authBuffer, const Cancellable* pCancellable) NN_NOEXCEPT
{
    nifm::NetworkConnection connection;
    NN_RESULT_DO(ConnectToInternet(connection, nifm::RequirementPreset_InternetBestEffort, pCancellable));

    FsChallenge challenge;
    NN_RESULT_DO(m_FsManager.GetChallenge(challenge.data, sizeof(challenge.data)));

    FsKeySeed fsKeySeed;
    NN_RESULT_DO(Authenticator::AuthenticateWithOneTimeCode(
        &fsKeySeed, &m_Resource.fsKeySeedDigest,
        *m_pLogin, challenge, ott,
        &authBuffer, sizeof(authBuffer), pCancellable));

    connection.CancelRequest();

    return m_FsManager.SetToken(fsKeySeed.data, sizeof(fsKeySeed.data));
}

Result IdcClientBase::OpenSaveDataImporter(std::unique_ptr<fs::SaveDataImporter>* pOut, const account::Uid& uid, const DataInfo& dataInfo, const void* initialData, size_t initialDataSize) NN_NOEXCEPT
{
    std::unique_ptr<fs::SaveDataImporter> pImpl;
    int64_t requiredSize;
    NN_RESULT_DO(m_FsManager.OpenSaveDataImporter(&pImpl, &requiredSize, initialData, initialDataSize, uid, dataInfo.spaceId));
    NN_RESULT_THROW_UNLESS(Match(dataInfo, pImpl->GetSaveDataInfo()), ResultUnexpectedDataBinaryResponded());

    *pOut = std::move(pImpl);
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::migration::detail
