﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/ldn/detail/Debug/ldn_Log.h>
#include <nn/ldn/detail/Service/ldn_ServiceName.h>
#include <nn/ldn/detail/Service/ldn_CreateServiceByDfc.h>
#include <nn/sf/sf_HipcServer.h>

namespace nn { namespace ldn { namespace server { namespace
{
    struct ServerManagerOption
    {
        static const size_t PointerTransferBufferSize = 4 * 1024;
    };

    class ServerManager : public nn::sf::HipcSimpleAllInOneServerManager<12, 3, ServerManagerOption>
    {
    };

    std::aligned_storage<sizeof(ServerManager), NN_ALIGNOF(ServerManager)>::type
        g_ServerManagerStorage;
    ServerManager* g_pServerManager;

}}}} // namespace nn::ldn::server::<unnamed>

namespace nn { namespace ldn { namespace server
{
    void InitializeServer() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!g_pServerManager);
        g_pServerManager = new (&g_ServerManagerStorage) ServerManager;

        NN_ABORT_UNLESS_RESULT_SUCCESS(g_pServerManager->RegisterObjectForPort(
            detail::CreateUserServiceCreatorByDfc(),
            3, nn::ldn::detail::UserServiceName));

        NN_ABORT_UNLESS_RESULT_SUCCESS(g_pServerManager->RegisterObjectForPort(
            detail::CreateSystemServiceCreatorByDfc(),
            5, nn::ldn::detail::SystemServiceName));

        NN_ABORT_UNLESS_RESULT_SUCCESS(g_pServerManager->RegisterObjectForPort(
            detail::CreateMonitorServiceCreatorByDfc(),
            5, nn::ldn::detail::MonitorServiceName));

        g_pServerManager->Start();
        NN_LDN_LOG_INFO("Server started\n");
    }

    void LoopServer() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(g_pServerManager);
        g_pServerManager->LoopAuto();
    }

}}} // namespace nn::ldn::server
