﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/diag/text/diag_SdkTextLdn.h>
#include <nn/ldn/ldn_Ssid.h>

namespace nn { namespace ldn
{
    Ssid MakeSsid() NN_NOEXCEPT
    {
        Ssid ssid = { 0 };
        return ssid;
    }

    Ssid MakeSsid(const char* raw) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(raw);
        Ssid ssid;
        for (ssid.length = 0; raw[ssid.length] != 0; ++ssid.length)
        {
            ssid.raw[ssid.length] = raw[ssid.length];
        }
        NN_SDK_REQUIRES(ssid.length <= SsidLengthMax, NN_TEXT_LDN("SSID は 32 文字以下で指定してください。"));
        ssid.raw[ssid.length] = 0;
        return ssid;
    }

    Ssid MakeSsid(const void* raw, size_t length) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(raw);
        NN_SDK_REQUIRES(length <= SsidLengthMax, NN_TEXT_LDN("SSID は 32 文字以下で指定してください。"));
        Ssid ssid;
        auto str = static_cast<const char*>(raw);
        for (ssid.length = 0; ssid.length < length; ++ssid.length)
        {
            ssid.raw[ssid.length] = str[ssid.length];
        }
        ssid.raw[ssid.length] = 0;
        return ssid;
    }

    bool IsValidSsid(const Ssid& ssid) NN_NOEXCEPT
    {
        // SSID は 1 文字以上 32 文字以下でなければなりません。
        if (ssid.length < 1 || SsidLengthMax < ssid.length)
        {
            return false;
        }

        // SSID は 0 で終端されていなければなりません。
        if (ssid.raw[ssid.length] != 0)
        {
            return false;
        }

        return true;
    }

}} // namespace nn::ldn

namespace nn { namespace ldn { namespace detail
{
    size_t ConvertToString(const Ssid& ssid, char* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(buffer != nullptr);
        NN_SDK_ASSERT(StringizedSsidLengthMax < bufferSize);
        size_t i = 0;
        for (i = 0; i < ssid.length && i + 1 < bufferSize; ++i)
        {
            buffer[i] = 0x20 <= ssid.raw[i] && ssid.raw[i] <= 0x7E ? ssid.raw[i] : 0;
        }
        buffer[i] = 0;
        return ssid.length;
    }

}}} // namespace nn::ldn
