﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/ldn/ldn_MacAddress.h>
#include <nn/util/util_FormatString.h>

namespace nn { namespace ldn { namespace detail { namespace
{
}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    size_t ConvertToString(MacAddress macAddress, char* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(buffer != nullptr);
        NN_SDK_ASSERT(StringizedMacAddressLength < bufferSize);
        return static_cast<size_t>(nn::util::SNPrintf(
            buffer, bufferSize, "%02x-%02x-%02x-%02x-%02x-%02x",
            macAddress.raw[0], macAddress.raw[1], macAddress.raw[2],
            macAddress.raw[3], macAddress.raw[4], macAddress.raw[5]));
    }

}}} // namespace nn::ldn
