﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldn/detail/Debug/ldn_Log.h>
#include <nn/ldn/detail/Service/ldn_SystemLocalCommunicationService.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ldn { namespace detail { namespace
{

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    SystemLocalCommunicationService::SystemLocalCommunicationService(
        LocalCommunicationServiceManager* pManager) NN_NOEXCEPT
        : LocalCommunicationServiceBase(pManager)
    {
    }

    SystemLocalCommunicationService::~SystemLocalCommunicationService() NN_NOEXCEPT
    {
    }

    Result SystemLocalCommunicationService::Initialize(Bit64 pid) NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        NN_LDN_LOG_INFO("context %d created by pid=%llu (system)\n", m_Context, pid);
        NetworkInterfaceRequestParameter param = { };
        param.priority = static_cast<int16_t>(DefaultSystemPriority);
        NN_RESULT_DO(m_pManager->StartLocalCommunication(m_Context, pid, param));
        NN_RESULT_SUCCESS;
    }

    Result SystemLocalCommunicationService::Finalize() NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        m_pManager->StopLocalCommunication(m_Context);
        NN_RESULT_SUCCESS;
    }

    Result SystemLocalCommunicationService::SetOperationMode(Bit32 mode) NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        NN_RESULT_DO(m_pManager->SetOperationMode(m_Context, static_cast<OperationMode>(mode)));
        NN_RESULT_SUCCESS;
    }

}}} // namespace nn::ldn::detail
