﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldn/detail/Service/ldn_Service.sfdl.h>
#include <nn/ldn/detail/Service/ldn_ServiceName.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClientProxyByName.h>

namespace nn { namespace ldn { namespace detail { namespace
{
    struct CreateServiceByHipcTag;
    typedef nn::sf::ExpHeapStaticAllocator<16 * 1024, CreateServiceByHipcTag> Allocator;

    class AllocatorInitializer
    {
    public:
        AllocatorInitializer() NN_NOEXCEPT
        {
            Allocator::Initialize(nn::lmem::CreationOption_NoOption);
        }
    } g_AllocatorInitializer;

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    nn::sf::SharedPointer<IUserServiceCreator> CreateUserServiceCreatorByHipc() NN_NOEXCEPT
    {
        nn::sf::SharedPointer<IUserServiceCreator> pAccessor;
        auto result = nn::sf::CreateHipcProxyByName<IUserServiceCreator, Allocator::Policy>(
            &pAccessor, UserServiceName);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        NN_SDK_ASSERT(pAccessor);
        return pAccessor;
    }

    nn::sf::SharedPointer<IMonitorServiceCreator> CreateMonitorServiceCreatorByHipc() NN_NOEXCEPT
    {
        nn::sf::SharedPointer<IMonitorServiceCreator> pAccessor;
        auto result = nn::sf::CreateHipcProxyByName<IMonitorServiceCreator, Allocator::Policy>(
            &pAccessor, MonitorServiceName);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        NN_SDK_ASSERT(pAccessor);
        return pAccessor;
    }

    nn::sf::SharedPointer<ISystemServiceCreator> CreateSystemServiceCreatorByHipc() NN_NOEXCEPT
    {
        nn::sf::SharedPointer<ISystemServiceCreator> pAccessor;
        auto result = nn::sf::CreateHipcProxyByName<ISystemServiceCreator, Allocator::Policy>(
            &pAccessor, SystemServiceName);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        NN_SDK_ASSERT(pAccessor);
        return pAccessor;
    }

}}} // namespace nn::ldn::detail
